/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.tileentity.specialized;

import dalapo.factech.auxiliary.MachineRecipes;
import dalapo.factech.helper.FacStackHelper;
import dalapo.factech.helper.Logger;
import dalapo.factech.tileentity.TileEntityFluidMachine;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityCrucible
extends TileEntityFluidMachine {
    public TileEntityCrucible() {
        super("crucible", 1, 2, 1, 1, 0);
    }

    @Override
    protected boolean canRun() {
        return super.canRun() && this.hasWork;
    }

    @Override
    public void getHasWork() {
        if (this.tanks == null) {
            return;
        }
        FluidStack potentialOut = this.getOutput(this.getInput(0));
        this.hasWork = potentialOut == null ? false : this.tanks[0].getFluid() == null || this.tanks[0].getFluid().isFluidEqual(potentialOut) && this.tanks[0].getFluidAmount() + potentialOut.amount <= 10000;
    }

    @Override
    protected boolean performAction() {
        Logger.info(this.getOutput(this.getInput(0)));
        this.tanks[0].fillInternal(this.getOutput(this.getInput(0)), true);
        this.getInput(0).func_190918_g(1);
        this.getHasWork();
        return true;
    }

    protected FluidStack getOutput(ItemStack is) {
        for (MachineRecipes.MachineRecipe<ItemStack, FluidStack> entry : this.getRecipeList()) {
            ItemStack in = entry.input().func_77946_l();
            FluidStack out = entry.output().copy();
            if (!FacStackHelper.matchStacksWithWildcard(in, is, true) || in.func_190916_E() > is.func_190916_E()) continue;
            return out;
        }
        return null;
    }

    public List<MachineRecipes.MachineRecipe<ItemStack, FluidStack>> getRecipeList() {
        return MachineRecipes.CRUCIBLE;
    }

    @Override
    public int getBaseOpTicks() {
        return 60;
    }

    @Override
    public void onTankUpdate() {
        super.onTankUpdate();
    }
}

