/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.tileentity.specialized;

import dalapo.factech.helper.DecoCoilLink;
import dalapo.factech.helper.DecoCoilLinkGraph;
import dalapo.factech.tileentity.TileEntityBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityDecoCoil
extends TileEntityBase
implements ITickable {
    private DecoCoilLinkGraph links;
    private List<BlockPos> nbtConnections;
    private boolean connected = false;
    private double[][] positions = new double[3][3];
    private double[][] velocities = new double[3][3];
    private long[] prevTimes = new long[]{0L, 0L, 0L};
    private double[] targetTimes = new double[]{0.0, 0.0, 0.0};
    private static final Vec3d HALFBLOCK = new Vec3d(0.5, 0.5, 0.5);
    private static final String NEIGHBOURS_NBTKEY = "TEDCNeighbours";

    public TileEntityDecoCoil() {
        super("decocoil");
        this.links = new DecoCoilLinkGraph();
        this.links.addVertex(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void render(float partialTicks, double x, double y, double z) {
        Tessellator v5 = Tessellator.func_178181_a();
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)1);
        GlStateManager.func_179118_c();
        GlStateManager.func_179089_o();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_187441_d((float)3.0f);
        BufferBuilder buffer = v5.func_178180_c();
        if (!this.isPoweredThroughConnections()) {
            for (DecoCoilLink link : this.links.getOutgoingLinks(this)) {
                buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
                link.update(this.field_145850_b);
                link.draw(this.field_145850_b, buffer, partialTicks);
                v5.func_78381_a();
            }
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179129_p();
        GlStateManager.func_179084_k();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179112_b((int)770, (int)0);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
        GlStateManager.func_179141_d();
        GlStateManager.func_179121_F();
    }

    public void func_73660_a() {
        if (!this.connected && this.field_145850_b != null && this.nbtConnections != null) {
            for (BlockPos blockPos : this.nbtConnections) {
                if (!(this.field_145850_b.func_175625_s(blockPos) instanceof TileEntityDecoCoil)) continue;
                TileEntityDecoCoil.link(this, (TileEntityDecoCoil)this.field_145850_b.func_175625_s(blockPos), false);
            }
            this.connected = true;
        }
        if (!this.isPoweredThroughConnections()) {
            Vec3d centerVec = new Vec3d((Vec3i)this.func_174877_v()).func_178787_e(HALFBLOCK);
            for (TileEntityDecoCoil other : this.links.getNeighbours(this)) {
                Vec3d neighbourVec = new Vec3d((Vec3i)other.func_174877_v()).func_178787_e(HALFBLOCK);
                List nearbyEntities = this.field_145850_b.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.field_174879_c, other.func_174877_v()));
                for (EntityLivingBase entity : nearbyEntities) {
                    if (entity.func_174813_aQ() == null || entity.func_174813_aQ().func_72327_a(centerVec, neighbourVec) == null) continue;
                    this.affectEntity(entity);
                }
            }
        }
    }

    private void affectEntity(EntityLivingBase entity) {
        entity.func_70097_a(new DamageSource("tesla").func_76348_h(), 2.0f);
    }

    private boolean isPoweredThroughConnections() {
        return this.links.isPowered(this);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.links.removeVertex(this);
    }

    public static boolean link(TileEntityDecoCoil first, TileEntityDecoCoil second, boolean manual) {
        if (first.links.hasEdge(first, second) && manual) {
            first.links.removeEdge(first, second);
            return false;
        }
        first.links.merge(second.links);
        first.links.addEdge(first, second);
        return true;
    }

    public void setLinks(DecoCoilLinkGraph newLinks, DecoCoilLinkGraph.DCLG privacyGuarantee) {
        if (privacyGuarantee == null) {
            return;
        }
        this.links = newLinks;
        this.links.addVertex(this);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.links != null) {
            NBTTagList tagList = new NBTTagList();
            for (TileEntityDecoCoil neighbour : this.links.getNeighbours(this)) {
                tagList.func_74742_a((NBTBase)new NBTTagLong(neighbour.func_174877_v().func_177986_g()));
            }
            nbt.func_74782_a(NEIGHBOURS_NBTKEY, (NBTBase)tagList);
        }
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.nbtConnections = new ArrayList<BlockPos>();
        if (nbt.func_74764_b(NEIGHBOURS_NBTKEY)) {
            NBTTagList neighbourTagList = (NBTTagList)nbt.func_74781_a(NEIGHBOURS_NBTKEY);
            for (int i = 0; i < neighbourTagList.func_74745_c(); ++i) {
                this.nbtConnections.add(BlockPos.func_177969_a((long)((NBTTagLong)neighbourTagList.func_179238_g(i)).func_150291_c()));
            }
        }
        this.connected = false;
    }
}

