/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.tileentity.specialized;

import dalapo.factech.FactoryTech;
import dalapo.factech.helper.FacMathHelper;
import dalapo.factech.helper.Logger;
import dalapo.factech.init.ItemRegistry;
import dalapo.factech.reference.PartList;
import dalapo.factech.tileentity.TileEntityBasicInventory;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class TileEntityEnergizer
extends TileEntityBasicInventory
implements ITickable {
    public static final List<Class<? extends TileEntity>> BLACKLIST = new ArrayList<Class<? extends TileEntity>>();
    public static final int EXTRA_TICKS = 1;
    private boolean hasCore;
    private int age;

    public TileEntityEnergizer() {
        super("energizer", 1);
    }

    public static boolean blacklistTileEntity(String classname) {
        Class te;
        try {
            te = ReflectionHelper.getClass((ClassLoader)FactoryTech.class.getClassLoader(), (String[])new String[]{classname});
        }
        catch (ReflectionHelper.UnableToFindClassException e) {
            Logger.error("Unable to find class " + classname + " to blacklist from Universal Supercharger; is it formatted properly?");
            return false;
        }
        if (TileEntity.class.isAssignableFrom(te)) {
            BLACKLIST.add(te);
            return true;
        }
        return false;
    }

    public boolean isCharging() {
        return this.hasCore;
    }

    @Override
    public void onInventoryChanged(int slot) {
        if (!this.hasCore && this.func_70301_a(slot).func_77969_a(new ItemStack((Item)ItemRegistry.machinePart, 1, PartList.CORE.getFloor()))) {
            this.func_70301_a(slot).func_190918_g(1);
            this.hasCore = true;
        }
    }

    public void func_73660_a() {
        if (this.hasCore && this.field_145850_b.func_175687_A(this.field_174879_c) == 0) {
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                TileEntity te = this.field_145850_b.func_175625_s(FacMathHelper.withOffset(this.field_174879_c, dir));
                if (!(te instanceof ITickable) || BLACKLIST.contains(te.getClass())) continue;
                for (int i = 0; i < 1; ++i) {
                    ((ITickable)te).func_73660_a();
                }
            }
            if (++this.age >= 600) {
                this.age = 0;
                if (this.func_70301_a(0).func_190926_b()) {
                    this.hasCore = false;
                } else if (!this.field_145850_b.field_72995_K) {
                    EntityItem ei = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, new ItemStack((Item)ItemRegistry.salvagePart, 1, 170));
                    this.field_145850_b.func_72838_d((Entity)ei);
                    this.func_70298_a(0, 1);
                }
                this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
            }
        }
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("core")) {
            this.hasCore = nbt.func_74767_n("core");
        }
        if (nbt.func_74764_b("age")) {
            this.age = nbt.func_74762_e("age");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("core", this.hasCore);
        nbt.func_74768_a("age", this.age);
        return nbt;
    }

    static {
        TileEntityEnergizer.blacklistTileEntity("dalapo.factech.tileentity.specialized.TileEntityEnergizer");
    }
}

