/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.tileentity.specialized;

import dalapo.factech.block.fluid.FluidBase;
import dalapo.factech.config.FacTechConfigManager;
import dalapo.factech.helper.FacMathHelper;
import dalapo.factech.init.ModFluidRegistry;
import dalapo.factech.tileentity.TileEntityFluidMachine;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityFluidDrill
extends TileEntityFluidMachine {
    private boolean drillSulphur;
    private int mbPerOperation;

    public TileEntityFluidDrill() {
        super("fluiddrill", 0, 3, 0, 1, 0);
    }

    @Override
    public void onLoad() {
        Random rand = this.field_145850_b.func_175726_f(this.field_174879_c).func_76617_a(0L);
        this.drillSulphur = rand.nextBoolean();
        this.mbPerOperation = rand.nextInt(150) + 10;
        if (rand.nextInt(4) == 0) {
            this.mbPerOperation += rand.nextInt(100);
        }
        this.getHasWork();
    }

    @Override
    public void getHasWork() {
        for (int i = 1; i < this.field_174879_c.func_177956_o(); ++i) {
            if (this.field_145850_b.func_180495_p(FacMathHelper.withOffsetAndDist(this.field_174879_c, EnumFacing.DOWN, i)).func_177230_c() != Blocks.field_150357_h || !this.field_145850_b.func_175623_d(FacMathHelper.withOffsetAndDist(this.field_174879_c, EnumFacing.DOWN, i))) {
                this.hasWork = false;
            }
            if (i == this.field_174879_c.func_177956_o()) break;
        }
        this.hasWork = true;
    }

    @Override
    public boolean canRun() {
        return super.canRun() && this.tanks[0].getFluidAmount() <= 10000 - this.mbPerOperation && this.hasWork;
    }

    @Override
    protected boolean performAction() {
        FluidBase fluid = this.drillSulphur ? ModFluidRegistry.sulphur : ModFluidRegistry.propane;
        this.tanks[0].fillInternal(new FluidStack((Fluid)fluid, (int)((float)this.mbPerOperation * FacTechConfigManager.fluidDrillMultiplier)), true);
        return true;
    }

    @Override
    public int getBaseOpTicks() {
        return 30;
    }

    @Override
    public void onTankUpdate() {
    }

    public boolean isSulphur() {
        return this.drillSulphur;
    }

    public int amountPer() {
        return this.mbPerOperation;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("sulphur", this.drillSulphur);
        nbt.func_74768_a("mb", this.mbPerOperation);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.drillSulphur = nbt.func_74767_n("sulphur");
        this.mbPerOperation = nbt.func_74762_e("mb");
    }
}

