/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.tileentity.specialized;

import dalapo.factech.auxiliary.MachineRecipes;
import dalapo.factech.config.FacTechConfigManager;
import dalapo.factech.helper.FacStackHelper;
import dalapo.factech.tileentity.TileEntityBasicProcessor;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class TileEntityGrindstone
extends TileEntityBasicProcessor {
    public TileEntityGrindstone() {
        super("grindstone", 1);
    }

    @Override
    protected List<MachineRecipes.MachineRecipe<ItemStack, ItemStack>> getRecipeList() {
        return MachineRecipes.GRINDSTONE;
    }

    @Override
    public void getHasWork() {
        super.getHasWork();
        ItemStack input = this.getInput(0);
        if (input.func_77973_b() instanceof ItemSword || input.func_77973_b() instanceof ItemTool) {
            this.hasWork = true;
        }
    }

    private boolean processEquipment(int enchID) {
        ItemStack toolOut = this.getInput(0).func_77946_l();
        NBTTagList enchantments = toolOut.func_77986_q();
        toolOut.func_77983_a("ench", (NBTBase)enchantments);
        for (int i = 0; i < enchantments.func_74745_c(); ++i) {
            NBTTagCompound ench = enchantments.func_150305_b(i);
            if (ench.func_74762_e("id") != enchID) continue;
            if (ench.func_74762_e("lvl") < 3) {
                ench.func_74768_a("lvl", ench.func_74762_e("lvl") + 1);
                toolOut.func_77964_b(toolOut.func_77958_k() - (int)((double)FacStackHelper.getRemainingDurability(toolOut) * 0.75));
                this.setOutput(toolOut);
                this.getInput(0).func_190918_g(1);
                return true;
            }
            return false;
        }
        NBTTagCompound ench = new NBTTagCompound();
        ench.func_74768_a("id", enchID);
        ench.func_74768_a("lvl", 1);
        toolOut.func_77986_q().func_74742_a((NBTBase)ench);
        toolOut.func_77964_b(toolOut.func_77958_k() - (int)((double)FacStackHelper.getRemainingDurability(toolOut) * 0.75));
        this.setOutput(toolOut);
        this.getInput(0).func_190918_g(1);
        return true;
    }

    @Override
    public boolean performAction() {
        if (FacTechConfigManager.allowMachineEnchanting && this.getInput(0).func_77973_b() instanceof ItemSword) {
            return this.processEquipment(16);
        }
        if (FacTechConfigManager.allowMachineEnchanting && this.getInput(0).func_77973_b() instanceof ItemTool) {
            return this.processEquipment(32);
        }
        return super.performAction();
    }

    @Override
    public int getBaseOpTicks() {
        return 60;
    }
}

