/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.tileentity.specialized;

import dalapo.factech.helper.FacStackHelper;
import dalapo.factech.init.ItemRegistry;
import dalapo.factech.tileentity.TileEntityMachine;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityPropaneFurnace
extends TileEntityMachine {
    private int propaneRemaining = 0;

    public TileEntityPropaneFurnace() {
        super("propanefurnace", 2, 0, 2);
    }

    @Override
    protected boolean canInsertIntoThisSlot(int slot, ItemStack item) {
        return item.func_77973_b() == ItemRegistry.tank & item.func_77952_i() == 3 ^ slot == 0;
    }

    public int getPropane() {
        return this.propaneRemaining;
    }

    @Override
    public void getHasWork() {
        ItemStack is = this.findOutput();
        this.hasWork = !is.func_190926_b() && FacStackHelper.canCombineStacks(this.getOutput(0), is) && this.propaneRemaining > 0;
    }

    @Nonnull
    private ItemStack findOutput() {
        Map recipes = FurnaceRecipes.func_77602_a().func_77599_b();
        for (Map.Entry smelt : recipes.entrySet()) {
            if (!FacStackHelper.matchStacksWithWildcard((ItemStack)smelt.getKey(), this.getInput(), false)) continue;
            return ((ItemStack)smelt.getValue()).func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    private void consumeFuelTank() {
        if (FacStackHelper.matchStacks(this.getInput(1), ItemRegistry.tank, 3)) {
            this.propaneRemaining += 8;
            this.getInput(1).func_190918_g(1);
            this.doOutput(new ItemStack((Item)ItemRegistry.tank, 1, 0), 1);
        }
    }

    @Override
    public void onInventoryChanged(int slot) {
        super.onInventoryChanged(slot);
        if (slot == 1 && this.propaneRemaining <= 0) {
            this.consumeFuelTank();
        }
    }

    @Override
    protected boolean performAction() {
        if (this.doOutput(this.findOutput())) {
            if (--this.propaneRemaining <= 0) {
                this.consumeFuelTank();
            }
            this.getInput(0).func_190918_g(1);
        }
        return true;
    }

    @Override
    public int getBaseOpTicks() {
        return 30;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("propane", this.propaneRemaining);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.propaneRemaining = nbt.func_74762_e("propane");
    }
}

