/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.tileentity.specialized;

import dalapo.factech.config.FacTechConfigManager;
import dalapo.factech.helper.FacMathHelper;
import dalapo.factech.helper.Pair;
import dalapo.factech.tileentity.TileEntityMachine;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;

public class TileEntitySluice
extends TileEntityMachine {
    private static boolean isUniversal = false;
    public static final List<Pair<ItemStack, Double>> outputs = new ArrayList<Pair<ItemStack, Double>>();
    private static List<Integer> allowedBiomes = new ArrayList<Integer>();
    private boolean hasWater = true;
    private boolean isInStream = false;

    public static void genBiomeWhitelist() {
        String[] raw;
        for (String str : raw = FacTechConfigManager.grateBiomes.split(",")) {
            if (str.equals("all")) {
                isUniversal = true;
                break;
            }
            try {
                allowedBiomes.add(Integer.parseInt(str));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    public static void addValidOutput(ItemStack is, double chance) {
        outputs.add(new Pair<ItemStack, Double>(is, chance));
    }

    public TileEntitySluice() {
        super("sluice", 0, 1, 9);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.recalcWater();
    }

    private void recalcWater() {
        int waterBlocks = 0;
        for (int x = this.field_174879_c.func_177958_n() - 1; x <= this.field_174879_c.func_177958_n() + 1; ++x) {
            for (int y = this.field_174879_c.func_177956_o() - 1; y <= this.field_174879_c.func_177956_o() + 1; ++y) {
                for (int z = this.field_174879_c.func_177952_p() - 1; z <= this.field_174879_c.func_177952_p() + 1; ++z) {
                    if (this.field_145850_b.func_180495_p(new BlockPos(x, y, z)).func_185904_a() == Material.field_151586_h) {
                        ++waterBlocks;
                    }
                    if (!this.field_145850_b.func_180495_p(new BlockPos(x, y, z)).func_177230_c().getRegistryName().toString().contains("streams:river")) continue;
                    this.isInStream = true;
                    return;
                }
            }
        }
        this.isInStream = false;
        this.hasWater = waterBlocks >= 8;
    }

    private boolean isValidBiome() {
        return isUniversal || allowedBiomes.contains(Biome.func_185362_a((Biome)this.field_145850_b.func_180494_b(this.field_174879_c)));
    }

    public boolean isValidLocation() {
        return this.isInStream || this.hasWater && FacMathHelper.isInRange(this.field_174879_c.func_177956_o(), 60, 70) && this.isValidBiome();
    }

    @Override
    public boolean canRun() {
        return super.canRun() && this.isValidLocation();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
    }

    @Override
    public void onInventoryChanged(int slot) {
        super.onInventoryChanged(slot);
        this.recalcWater();
    }

    @Override
    protected boolean performAction() {
        for (Pair<ItemStack, Double> p : outputs) {
            if (!(Math.random() < (Double)p.b)) continue;
            this.doOutput(((ItemStack)p.a).func_77946_l());
        }
        this.recalcWater();
        return true;
    }

    @Override
    public int getBaseOpTicks() {
        return 240;
    }
}

