/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.tileentity.specialized;

import dalapo.factech.helper.FacBlockHelper;
import dalapo.factech.helper.FacMathHelper;
import dalapo.factech.init.ItemRegistry;
import dalapo.factech.packet.PacketHandler;
import dalapo.factech.packet.StabilizerPacket;
import dalapo.factech.reference.PartList;
import dalapo.factech.tileentity.TileEntityMachine;
import dalapo.factech.tileentity.specialized.TileEntityMagnet;
import java.util.Arrays;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class TileEntityStabilizer
extends TileEntityMachine {
    private short stability = 0;
    private int dS = 0;
    short[] magnetStrengths = new short[4];
    boolean[] isCooling = new boolean[4];

    public TileEntityStabilizer() {
        super("stabilizer", 1, 0, 1);
    }

    @Override
    public void sync() {
        super.sync();
        StabilizerPacket packet = new StabilizerPacket(this);
        PacketHandler.sendToAll(packet);
    }

    public boolean isCooling(int side) {
        return this.isCooling[side];
    }

    public short getStrength(int side) {
        return this.magnetStrengths[side];
    }

    public short getStability() {
        return this.stability;
    }

    public void updateValues(short stb, short[] str, boolean[] cool) {
        this.stability = stb;
        for (int i = 0; i < 4; ++i) {
            this.magnetStrengths[i] = str[i];
            this.isCooling[i] = cool[i];
        }
    }

    @Override
    public void getHasWork() {
        this.hasWork = this.getInput().func_77973_b().equals(ItemRegistry.coreUnfinished) && this.getInput().func_77952_i() < 40;
    }

    @Override
    public boolean canRun() {
        return true;
    }

    @Override
    protected boolean performAction() {
        for (int i = 2; i < 6; ++i) {
            TileEntity te = this.field_145850_b.func_175625_s(FacMathHelper.withOffsetAndDist(this.field_174879_c, EnumFacing.func_82600_a((int)i), 3));
            if (te instanceof TileEntityMagnet) {
                this.magnetStrengths[i - 2] = ((TileEntityMagnet)te).getStrength();
                this.isCooling[i - 2] = ((TileEntityMagnet)te).getCooldown() > 0;
                continue;
            }
            this.magnetStrengths[i - 2] = -1;
        }
        if (!this.getInput().func_77973_b().equals(ItemRegistry.coreUnfinished) || this.getInput().func_77952_i() > 40) {
            this.dS = 0;
        } else {
            double average = 0.0;
            short lowest = this.magnetStrengths[0];
            short highest = this.magnetStrengths[0];
            short[] tempStrengths = new short[4];
            for (int i = 0; i < 4; ++i) {
                short strength = this.magnetStrengths[i];
                if (strength < lowest) {
                    lowest = strength;
                }
                if (strength > highest) {
                    highest = strength;
                }
                average += (double)strength / 4.0;
                tempStrengths[i] = this.magnetStrengths[i];
            }
            Arrays.sort(tempStrengths);
            int biggestJump = tempStrengths[1] - tempStrengths[0];
            for (int i = 2; i < 4; ++i) {
                if (tempStrengths[i] - tempStrengths[i - 1] <= biggestJump) continue;
                biggestJump = tempStrengths[i] - tempStrengths[i - 1];
            }
            this.dS = (int)((average * 4.0 - (double)(2 * (highest - lowest)) - 2.0 * ((double)highest - average) - 2.0 * (average - (double)lowest) - (double)biggestJump) / 100.0);
            this.dS = (int)((double)this.dS * (1.0 - (0.05 * (double)Math.abs(this.getInput().func_77952_i()) - 20.0)));
        }
        this.stability = (short)(this.stability + this.dS);
        if (this.stability <= -200) {
            this.getIO().setStackInSlot(0, ItemStack.field_190927_a);
            this.field_145850_b.func_72876_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 4.0f, true);
        }
        if (this.stability >= 500 && this.getInput().func_185136_b(new ItemStack((Item)ItemRegistry.coreUnfinished))) {
            this.stability = 0;
            ItemStack is = new ItemStack((Item)ItemRegistry.machinePart, 1, PartList.CORE.getFloor());
            if (!this.doOutput(is)) {
                EntityItem ei = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, is);
                this.field_145850_b.func_72838_d((Entity)ei);
            }
            this.getIO().setStackInSlot(0, ItemStack.field_190927_a);
        }
        FacBlockHelper.updateBlock(this.field_145850_b, this.field_174879_c);
        return true;
    }

    @Override
    public int getBaseOpTicks() {
        return 10;
    }
}

