/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.tileentity.specialized;

import dalapo.factech.FactoryTech;
import dalapo.factech.auxiliary.IMachineRecipe;
import dalapo.factech.auxiliary.MachineRecipes;
import dalapo.factech.config.FacTechConfigManager;
import dalapo.factech.helper.FacStackHelper;
import dalapo.factech.tileentity.TileEntityMachine;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;

public class TileEntityTemperer
extends TileEntityMachine {
    private static final int deltaT = 2;
    private boolean hasRedstone = false;
    private boolean hadRedstone = false;
    private int activeRecipe = -1;
    private int activeTime = 0;

    public TileEntityTemperer() {
        super("temperer", 1, 3, 1);
    }

    private void checkActiveRecipe() {
        ItemStack input = this.getInput();
        if (FacTechConfigManager.allowMachineEnchanting) {
            if (input.func_77973_b() == Items.field_151040_l || input.func_77973_b() instanceof ItemTool && ((ItemTool)input.func_77973_b()).func_77861_e() == "IRON") {
                this.activeRecipe = -2;
                this.activeTime = 83;
                return;
            }
            if (input.func_77973_b() instanceof ItemArmor && ((ItemArmor)input.func_77973_b()).func_82812_d() == ItemArmor.ArmorMaterial.IRON) {
                this.activeRecipe = -2;
                this.activeTime = 116;
                return;
            }
        }
        for (int i = 0; i < MachineRecipes.TEMPERER.size(); ++i) {
            if (!FacStackHelper.matchStacksWithWildcard(input, MachineRecipes.TEMPERER.get((int)i).input)) continue;
            this.activeRecipe = i;
            this.activeTime = MachineRecipes.TEMPERER.get((int)i).time;
            return;
        }
        this.activeRecipe = -1;
    }

    @Override
    public void getHasWork() {
        this.checkActiveRecipe();
        this.hasWork = this.activeRecipe != -1;
    }

    public int getActiveTime() {
        return this.activeTime;
    }

    @Override
    public int getProgressScaled(int pixelSize) {
        return (int)((double)this.opTicks / 120.0 * (double)pixelSize);
    }

    public boolean successfulWindow() {
        return this.opTicks >= this.activeTime - 2 && this.opTicks <= this.activeTime + 2;
    }

    public ItemStack getRecipeOutput() {
        if (this.activeRecipe == -1) {
            return ItemStack.field_190927_a;
        }
        if (this.activeRecipe == -2) {
            return this.getInput();
        }
        return MachineRecipes.TEMPERER.get((int)this.activeRecipe).output.func_77946_l();
    }

    @Override
    public boolean canRun() {
        return super.canRun() && (this.hasRedstone || this.hadRedstone) && this.activeRecipe != -1;
    }

    @Override
    public void func_73660_a() {
        boolean bl = this.hasRedstone = this.field_145850_b.func_175687_A(this.field_174879_c) > 0;
        if (this.canRun()) {
            this.isRunning = true;
            if (this.opTicks++ > this.activeTime + 2) {
                if (!this.field_145850_b.field_72995_K) {
                    this.field_145850_b.func_184133_a((EntityPlayer)null, this.field_174879_c, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 1.0f, 2.6f + (FactoryTech.random.nextFloat() - FactoryTech.random.nextFloat()) * 0.8f);
                } else {
                    for (int i = 0; i < 8; ++i) {
                        this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)this.field_174879_c.func_177958_n() + FactoryTech.random.nextFloat()), (double)((float)this.field_174879_c.func_177956_o() + FactoryTech.random.nextFloat()) + 0.5, (double)((float)this.field_174879_c.func_177952_p() + FactoryTech.random.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
                    }
                }
                this.getInput(0).func_190918_g(1);
                this.opTicks = 0;
            }
            if (this.hadRedstone && !this.hasRedstone) {
                if (this.opTicks > this.activeTime - 2 && !this.field_145850_b.field_72995_K) {
                    if (this.performAction()) {
                        this.cycleParts();
                    }
                    this.getHasWork();
                    this.func_70296_d();
                    this.sync();
                }
                this.opTicks = 0;
            }
        } else {
            this.opTicks = 0;
            this.isRunning = false;
        }
        this.replenishParts();
        this.hadRedstone = this.hasRedstone;
    }

    @Override
    protected boolean performAction() {
        ItemStack out;
        if (this.activeRecipe == -2) {
            return this.processEquipment();
        }
        if (this.activeRecipe != -1 && this.doOutput(out = MachineRecipes.TEMPERER.get((int)this.activeRecipe).output.func_77946_l())) {
            this.getInput().func_190918_g(1);
            return true;
        }
        return false;
    }

    private boolean processEquipment() {
        ItemStack toolOut = this.getInput(0).func_77946_l();
        NBTTagList enchantments = toolOut.func_77986_q();
        toolOut.func_77983_a("ench", (NBTBase)enchantments);
        for (int i = 0; i < enchantments.func_74745_c(); ++i) {
            NBTTagCompound ench = enchantments.func_150305_b(i);
            if (ench.func_74762_e("id") != 34) continue;
            return false;
        }
        NBTTagCompound ench = new NBTTagCompound();
        ench.func_74768_a("id", 34);
        ench.func_74768_a("lvl", 1);
        toolOut.func_77986_q().func_74742_a((NBTBase)ench);
        this.setOutput(toolOut);
        this.getInput(0).func_190918_g(1);
        return true;
    }

    @Override
    public int getBaseOpTicks() {
        return this.activeTime;
    }

    public static class TempererRecipe
    implements IMachineRecipe<ItemStack> {
        final ItemStack input;
        final ItemStack output;
        final int time;

        public TempererRecipe(ItemStack in, ItemStack out, int t) {
            this.input = in;
            this.output = out;
            this.time = t < 5 ? 5 : t;
        }

        public ItemStack getInput() {
            return this.input;
        }

        public ItemStack getOutput() {
            return this.output;
        }

        @Override
        public ItemStack getOutputStack() {
            return this.getOutput();
        }

        public int getTime() {
            return this.time;
        }
    }
}

