/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.world;

import dalapo.factech.auxiliary.EnumOreType;
import dalapo.factech.config.FacTechConfigManager;
import dalapo.factech.init.BlockRegistry;
import dalapo.factech.reference.StateList;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;

public class OreGenerator
implements IWorldGenerator {
    public List<OreGen> ores = new ArrayList<OreGen>();
    public static List<Integer> dimBlackList = new ArrayList<Integer>();

    public OreGenerator() {
        if (FacTechConfigManager.genCopper) {
            this.ores.add(new OreGen("copper", BlockRegistry.ore.func_176223_P().func_177226_a(StateList.oretype, (Comparable)((Object)EnumOreType.COPPER)), FacTechConfigManager.copperMin, FacTechConfigManager.copperMax, Blocks.field_150348_b, 8, 9, 65));
        }
        if (FacTechConfigManager.genNickel) {
            this.ores.add(new OreGen("nickel", BlockRegistry.ore.func_176223_P().func_177226_a(StateList.oretype, (Comparable)((Object)EnumOreType.NICKEL)), FacTechConfigManager.nickelMin, FacTechConfigManager.nickelMax, Blocks.field_150348_b, 8, 8, 60));
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.getDimension() == 0) {
            for (OreGen ore : this.ores) {
                ore.generate(world, random, chunkX, chunkZ);
            }
        }
    }

    public static class OreGen {
        int minY;
        int maxY;
        WorldGenMinable genMinable;
        String name;
        int chunkOccurrence;
        int weight;

        public OreGen(String name, IBlockState state, int minY, int maxY, Block block, int veinSize, int chancesToSpawn, int weight) {
            this.name = name;
            this.weight = weight;
            this.minY = minY;
            this.maxY = maxY;
            this.genMinable = new WorldGenMinable(state, veinSize);
            this.chunkOccurrence = chancesToSpawn;
        }

        public void generate(World world, Random rand, int x, int z) {
            for (int i = 0; i < this.chunkOccurrence; ++i) {
                if (rand.nextInt(100) >= this.weight) continue;
                BlockPos pos = new BlockPos(x * 16 + rand.nextInt(16), this.minY + rand.nextInt(this.maxY - this.minY), z * 16 + rand.nextInt(16));
                this.genMinable.func_180709_b(world, rand, pos);
            }
        }
    }
}

