/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.lumberjack;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import net.doubledoordev.lumberjack.client.ClientHelper;
import net.doubledoordev.lumberjack.items.ItemLumberAxe;
import net.doubledoordev.lumberjack.util.EventHandler;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;

@Mod(modid="lumberjack", name="lumberjack", updateJSON="http://doubledoordev.net/lumberjack.json", guiFactory="net.doubledoordev.lumberjack.client.ModConfigGuiFactory", dependencies="after:D3Core", acceptedMinecraftVersions="[1.12.2]")
public class Lumberjack {
    @Mod.Instance(value="lumberjack")
    public static Lumberjack instance;
    private static Logger logger;
    private int totalLimit = 1024;
    private int tickLimit = 32;
    private int mode = 0;
    private boolean leaves = false;
    private static boolean useAllMaterials;
    private Configuration configuration;
    private String[] banList;
    public static List<Item> itemList;
    public static List<IRecipe> recipesList;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)EventHandler.I);
        MinecraftForge.EVENT_BUS.register((Object)new RegistrationHandler());
        this.configuration = new Configuration(event.getSuggestedConfigurationFile());
        this.updateConfig();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (event.getSide().isClient()) {
            ClientHelper.init();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("lumberjack")) {
            this.updateConfig();
        }
    }

    public static void registerItem(Item item, String name) {
        if (item.getRegistryName() == null) {
            item.setRegistryName(name);
        }
        itemList.add(item);
    }

    public static boolean isBlacklisted(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            return true;
        }
        for (String ban : Lumberjack.instance.banList) {
            if (ban.equalsIgnoreCase(name)) {
                logger.info("Material {} is blacklisted. It matches {} literally.", (Object)name, (Object)ban);
                return true;
            }
            if (ban.charAt(0) == '*' && name.endsWith(ban.substring(1))) {
                logger.info("Material {} is blacklisted. It matches {} as a suffix.", (Object)name, (Object)ban);
                return true;
            }
            if (ban.charAt(ban.length() - 1) != '*' || !name.startsWith(ban.substring(0, ban.length() - 2))) continue;
            logger.info("Material {} is blacklisted. It matches {} as a suffix.", (Object)name, (Object)ban);
            return true;
        }
        return false;
    }

    private void updateConfig() {
        this.configuration.setCategoryLanguageKey("lumberjack", "d3.lumberjack.config.lumberjack");
        this.totalLimit = this.configuration.getInt("totalLimit", "lumberjack", this.totalLimit, 1, 10000, "Hard limit of the amount that can be broken in one go.");
        this.tickLimit = this.configuration.getInt("tickLimit", "lumberjack", this.tickLimit, 1, 10000, "Hard limit of the amount that can be broken in one go.");
        this.mode = this.configuration.getInt("mode", "lumberjack", this.mode, 0, 1, "Valid modes:\n0: Only chop blocks with the same blockid\n1: Chop all wooden blocks");
        this.leaves = this.configuration.getBoolean("leaves", "lumberjack", this.leaves, "Harvest leaves too.");
        useAllMaterials = this.configuration.getBoolean("useAllMaterials", "lumberjack", useAllMaterials, "If you set this to false, we will only clone other axes, and not try to use all ToolMaterials.");
        this.banList = this.configuration.get("banlist", "lumberjack", new String[0], "A list of names you don't want to see as lumberaxes.\nNot case sensitive, but it uses the RAW ToolMaterial name. AKA it does not strip modid's or oter 'unique making techniques' mod authors may use to prevent conflicts with materials from other mods.\nUse * as a wildcard at the beginning or end to match with endsWith or startsWith respectively.\nExample: 'BASEMETALS_*' will prevent any material that starts with 'BASEMETALS_' from becoming a lumberaxe.", Pattern.compile("^\\*[A-z0-9_:|]+$|^[A-z0-9_:|]+\\*$|^[A-z0-9_:|]+$")).getStringList();
        if (this.configuration.hasChanged()) {
            this.configuration.save();
        }
    }

    public static Configuration getConfig() {
        return Lumberjack.instance.configuration;
    }

    public static Logger getLogger() {
        return logger;
    }

    public static int getTotalLimit() {
        return Lumberjack.instance.totalLimit;
    }

    public static int getTickLimit() {
        return Lumberjack.instance.tickLimit;
    }

    public static boolean getLeaves() {
        return Lumberjack.instance.leaves;
    }

    public static int getMode() {
        return Lumberjack.instance.mode;
    }

    static {
        useAllMaterials = false;
        itemList = new ArrayList<Item>();
        recipesList = new ArrayList<IRecipe>();
    }

    @Mod.EventBusSubscriber(modid="lumberjack")
    public static class RegistrationHandler {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void registerItemsEvent(RegistryEvent.Register<Item> event) {
            HashSet unusedMaterials = Sets.newHashSet((Object[])Item.ToolMaterial.values());
            for (Item i : ImmutableList.copyOf((Iterable)Item.field_150901_e)) {
                if (!(i instanceof ItemAxe)) continue;
                try {
                    ItemAxe axe = (ItemAxe)i;
                    Item.ToolMaterial m = axe.field_77862_b;
                    if (m == null || m.name() == null) {
                        logger.error("Found horribly broken axe {} with material {}. Please report.", (Object)i.getRegistryName(), (Object)m);
                        continue;
                    }
                    if (!unusedMaterials.remove(m) || ItemLumberAxe.usedMaterial(m)) {
                        logger.debug("Material {} ({}) already in use.", (Object)m, (Object)ItemLumberAxe.normalizeName(m));
                        continue;
                    }
                    if (Lumberjack.isBlacklisted(m.name())) continue;
                    new ItemLumberAxe(m, axe);
                }
                catch (Exception e) {
                    logger.warn("New Lumberaxe error. Axe trying to imitate: " + i.getRegistryName(), (Throwable)e);
                }
            }
            if (useAllMaterials) {
                for (Item.ToolMaterial m : unusedMaterials) {
                    try {
                        if (m == null || m.name() == null) {
                            logger.error("Found horribly broken material {}. Please report.", (Object)m);
                            continue;
                        }
                        if (ItemLumberAxe.usedMaterial(m)) {
                            logger.debug("Material {} ({}) already in use.", (Object)m, (Object)ItemLumberAxe.normalizeName(m));
                            continue;
                        }
                        if (Lumberjack.isBlacklisted(m.name())) continue;
                        new ItemLumberAxe(m);
                    }
                    catch (Exception e) {
                        logger.warn("New Lumberaxe error. ToolMaterial '" + m + "' will not exist.", (Throwable)e);
                    }
                }
            }
            for (Item item : itemList) {
                event.getRegistry().register((IForgeRegistryEntry)item);
            }
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void registerRecipesEvent(RegistryEvent.Register<IRecipe> event) {
            for (IRecipe item : recipesList) {
                event.getRegistry().register((IForgeRegistryEntry)item);
            }
        }
    }
}

