/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.lumberjack;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import cpw.mods.fml.client.config.IConfigElement;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.doubledoordev.d3core.D3Core;
import net.doubledoordev.d3core.util.ID3Mod;
import net.doubledoordev.lumberjack.items.ItemLumberAxe;
import net.doubledoordev.lumberjack.util.Constants;
import net.doubledoordev.lumberjack.util.Point;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.world.BlockEvent;
import org.apache.logging.log4j.Logger;

@Mod(modid="Lumberjack")
public class Lumberjack
implements ID3Mod {
    @Mod.Instance(value="Lumberjack")
    public static Lumberjack instance;
    public Logger logger;
    public int limit = 1024;
    public int mode = 0;
    public boolean leaves = false;
    public HashMultimap<String, Point> pointMap = HashMultimap.create();
    public HashMultimap<String, Point> nextMap = HashMultimap.create();
    private Configuration configuration;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.logger = event.getModLog();
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
        this.configuration = new Configuration(event.getSuggestedConfigurationFile());
        this.syncConfig();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (D3Core.debug()) {
            this.logger.info("Registering all tools");
        }
        HashSet<Item> items = new HashSet<Item>(Item.ToolMaterial.values().length);
        for (Item.ToolMaterial material : Item.ToolMaterial.values()) {
            try {
                if (material.func_150995_f() == null) {
                    if (!D3Core.debug()) continue;
                    this.logger.warn("The ToolMaterial " + material + " doesn't have a crafting item set. No LumberAxe from that!");
                    continue;
                }
                if (items.contains(material.func_150995_f())) {
                    if (!D3Core.debug()) continue;
                    this.logger.warn("The ToolMaterial " + material + " uses an item that has already been used.");
                    continue;
                }
                try {
                    new ItemLumberAxe(material);
                    items.add(material.func_150995_f());
                }
                catch (Exception e) {}
            }
            catch (Exception e) {
                this.logger.error("Some ToolMaterial has a corrupt state: " + material);
            }
        }
        if (D3Core.debug()) {
            this.logger.info("Table of materials");
            this.logger.info(Constants.makeTable(new Constants.TableData("Tool Material", ItemLumberAxe.toolMaterials), new Constants.TableData("Texture string", ItemLumberAxe.textureStrings), new Constants.TableData("Item name", ItemLumberAxe.itemNames), new Constants.TableData("Crafting Items", ItemLumberAxe.craftingItems)));
        }
    }

    @SubscribeEvent
    public void tickEvent(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (!event.side.isServer()) {
            return;
        }
        String name = event.player.func_70005_c_();
        if (!this.nextMap.containsKey((Object)name) || this.nextMap.get((Object)name).isEmpty()) {
            return;
        }
        for (Point point : ImmutableSet.copyOf((Collection)this.nextMap.get((Object)name))) {
            ((EntityPlayerMP)event.player).field_71134_c.func_73084_b(point.x, point.y, point.z);
            this.nextMap.remove((Object)name, (Object)point);
            if (this.pointMap.get((Object)name).size() <= this.limit) continue;
            this.nextMap.removeAll((Object)name);
        }
        if (!this.nextMap.containsKey((Object)name) || !this.nextMap.get((Object)name).isEmpty()) {
            this.pointMap.removeAll((Object)name);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @SubscribeEvent
    public void breakEvent(BlockEvent.BreakEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        if (!(event.block.func_149688_o() == Material.field_151575_d || this.leaves && event.block.func_149688_o() == Material.field_151584_j)) {
            return;
        }
        ItemStack itemStack = event.getPlayer().func_70694_bm();
        if (itemStack == null || !(itemStack.func_77973_b() instanceof ItemLumberAxe)) {
            return;
        }
        String name = event.getPlayer().func_70005_c_();
        this.pointMap.put((Object)name, (Object)new Point(event.x, event.y, event.z));
        int offsetX = -1;
        block4: while (offsetX <= 1) {
            int offsetZ = -1;
            while (true) {
                if (offsetZ <= 1) {
                } else {
                    ++offsetX;
                    continue block4;
                }
                block6: for (int offsetY = -1; offsetY <= 1; ++offsetY) {
                    int newX = event.x + offsetX;
                    int newY = event.y + offsetY;
                    int newZ = event.z + offsetZ;
                    Point newPoint = new Point(newX, newY, newZ);
                    if (this.nextMap.containsEntry((Object)name, (Object)newPoint) || this.pointMap.containsEntry((Object)name, (Object)newPoint)) continue;
                    Block newBlock = event.world.func_147439_a(newX, newY, newZ);
                    switch (this.mode) {
                        case 0: {
                            if (newBlock == event.block || this.leaves && newBlock.func_149688_o() == Material.field_151584_j) break;
                            continue block6;
                        }
                        case 1: {
                            if (newBlock.func_149688_o() != Material.field_151575_d && (!this.leaves || newBlock.func_149688_o() != Material.field_151584_j)) continue block6;
                        }
                    }
                    this.nextMap.put((Object)name, (Object)newPoint);
                }
                ++offsetZ;
            }
            break;
        }
        return;
    }

    public void syncConfig() {
        this.configuration.setCategoryLanguageKey("Lumberjack", "d3.lumberjack.config.lumberjack");
        this.limit = this.configuration.getInt("limit", "Lumberjack", this.limit, 1, 10000, "Hard limit of the amount that can be broken in one go. If you put this too high you might crash your server!! The maximum is dependant on your RAM settings.");
        this.mode = this.configuration.getInt("mode", "Lumberjack", this.mode, 0, 1, "Valid modes:\n0: Only chop blocks with the same blockid\n1: Chop all wooden blocks");
        this.leaves = this.configuration.getBoolean("leaves", "Lumberjack", this.leaves, "Harvest leaves too.");
        if (this.configuration.hasChanged()) {
            this.configuration.save();
        }
    }

    public void addConfigElements(List<IConfigElement> configElements) {
        configElements.add((IConfigElement)new ConfigElement(this.configuration.getCategory("Lumberjack".toLowerCase())));
    }
}

