/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.api;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import mchorse.metamorph.api.models.IMorphProvider;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.capabilities.morphing.IMorphing;
import mchorse.metamorph.capabilities.morphing.MorphingProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;

public class EntityUtils {
    private static List<String> removeAttributes = Lists.newArrayList((Object[])new String[]{"generic.followRange"});

    public static NBTTagCompound stripEntityNBT(NBTTagCompound tag) {
        tag.func_82580_o("Dimension");
        tag.func_82580_o("HurtTime");
        tag.func_82580_o("DeathTime");
        tag.func_82580_o("HurtByTimestamp");
        tag.func_82580_o("Health");
        tag.func_82580_o("PortalCooldown");
        tag.func_82580_o("Leashed");
        tag.func_82580_o("Air");
        tag.func_82580_o("id");
        tag.func_82580_o("Invulnerable");
        tag.func_82580_o("ArmorDropChances");
        tag.func_82580_o("HandDropChances");
        tag.func_82580_o("HandItems");
        tag.func_82580_o("Inventory");
        tag.func_82580_o("LeftHanded");
        tag.func_82580_o("CanPickUpLoot");
        tag.func_82580_o("Pos");
        tag.func_82580_o("Motion");
        tag.func_82580_o("Rotation");
        tag.func_82580_o("FallDistance");
        tag.func_82580_o("FallFlying");
        tag.func_82580_o("OnGround");
        tag.func_82580_o("Fire");
        tag.func_82580_o("ArmorItems");
        tag.func_82580_o("UUIDLeast");
        tag.func_82580_o("UUIDMost");
        if (tag.func_74764_b("Attributes")) {
            NBTTagList attributes = tag.func_150295_c("Attributes", 10);
            for (int i = attributes.func_74745_c() - 1; i >= 0; --i) {
                if (!removeAttributes.contains(attributes.func_150305_b(i).func_74779_i("Name"))) continue;
                attributes.func_74744_a(i);
            }
        }
        tag.func_82580_o("Peek");
        tag.func_82580_o("AttachFace");
        tag.func_82580_o("APX");
        tag.func_82580_o("APY");
        tag.func_82580_o("APZ");
        tag.func_82580_o("Anger");
        tag.func_82580_o("HurtBy");
        tag.func_82580_o("EggLayTime");
        return tag;
    }

    public static boolean compareData(NBTTagCompound a, NBTTagCompound b) {
        if (a.func_186856_d() != b.func_186856_d()) {
            return false;
        }
        for (String key : a.func_150296_c()) {
            NBTBase aTag = a.func_74781_a(key);
            NBTBase bTag = b.func_74781_a(key);
            if (bTag == null) {
                return false;
            }
            if (!(aTag instanceof NBTPrimitive) && !(aTag instanceof NBTTagString) || aTag.equals((Object)bTag)) continue;
            return false;
        }
        return true;
    }

    public static EntityEquipmentSlot slotForIndex(int index) {
        EntityEquipmentSlot slot = EntityEquipmentSlot.MAINHAND;
        switch (index) {
            case 1: {
                slot = EntityEquipmentSlot.OFFHAND;
                break;
            }
            case 2: {
                slot = EntityEquipmentSlot.FEET;
                break;
            }
            case 3: {
                slot = EntityEquipmentSlot.LEGS;
                break;
            }
            case 4: {
                slot = EntityEquipmentSlot.CHEST;
                break;
            }
            case 5: {
                slot = EntityEquipmentSlot.HEAD;
            }
        }
        return slot;
    }

    public static AbstractMorph getMorph(EntityLivingBase entity) {
        if (entity instanceof IMorphProvider) {
            return ((IMorphProvider)entity).getMorph();
        }
        IMorphing cap = (IMorphing)entity.getCapability(MorphingProvider.MORPHING_CAP, null);
        if (cap != null) {
            return cap.getCurrentMorph();
        }
        return null;
    }

    public static String getPose(EntityLivingBase entity, String custom, boolean sneak) {
        boolean empty = custom.isEmpty();
        if (!empty && !sneak) {
            return custom;
        }
        if (entity.func_184613_cA()) {
            return "flying";
        }
        if (entity.func_184218_aH()) {
            return "riding";
        }
        if (entity.func_70093_af()) {
            return sneak && !empty ? custom : "sneaking";
        }
        return "standing";
    }

    public static Entity getTargetEntity(Entity input, double maxReach) {
        double blockDistance = maxReach;
        RayTraceResult result = EntityUtils.rayTrace(input, maxReach, 1.0f);
        Vec3d eyes = new Vec3d(input.field_70165_t, input.field_70163_u + (double)input.func_70047_e(), input.field_70161_v);
        if (result != null) {
            blockDistance = result.field_72307_f.func_72438_d(eyes);
        }
        Vec3d look = input.func_70676_i(1.0f);
        Vec3d max = eyes.func_72441_c(look.field_72450_a * maxReach, look.field_72448_b * maxReach, look.field_72449_c * maxReach);
        Entity target = null;
        float area = 1.0f;
        List list = input.field_70170_p.func_175674_a(input, input.func_174813_aQ().func_72321_a(look.field_72450_a * maxReach, look.field_72448_b * maxReach, look.field_72449_c * maxReach).func_72314_b((double)area, (double)area, (double)area), (Predicate)new Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                return entity != null && entity.func_70067_L();
            }
        });
        double entityDistance = blockDistance;
        for (int i = 0; i < list.size(); ++i) {
            double eyesDistance;
            Entity entity = (Entity)list.get(i);
            if (entity == input) continue;
            AxisAlignedBB aabb = entity.func_174813_aQ().func_186662_g((double)entity.func_70111_Y());
            RayTraceResult intercept = aabb.func_72327_a(eyes, max);
            if (aabb.func_72318_a(eyes)) {
                if (!(entityDistance >= 0.0)) continue;
                target = entity;
                entityDistance = 0.0;
                continue;
            }
            if (intercept == null || !((eyesDistance = eyes.func_72438_d(intercept.field_72307_f)) < entityDistance) && entityDistance != 0.0) continue;
            if (entity.func_184208_bv() == input.func_184208_bv() && !input.canRiderInteract()) {
                if (entityDistance != 0.0) continue;
                target = entity;
                continue;
            }
            target = entity;
            entityDistance = eyesDistance;
        }
        return target;
    }

    public static RayTraceResult rayTrace(Entity input, double blockReachDistance, float partialTicks) {
        Vec3d eyePos = new Vec3d(input.field_70165_t, input.field_70163_u + (double)input.func_70047_e(), input.field_70161_v);
        Vec3d eyeDir = input.func_70676_i(partialTicks);
        Vec3d eyeReach = eyePos.func_72441_c(eyeDir.field_72450_a * blockReachDistance, eyeDir.field_72448_b * blockReachDistance, eyeDir.field_72449_c * blockReachDistance);
        return input.field_70170_p.func_147447_a(eyePos, eyeReach, false, false, true);
    }

    public static void forceUpdateSize(EntityPlayer player, AbstractMorph morph) {
        if (morph != null) {
            morph.updateSize((EntityLivingBase)player, morph.getWidth((EntityLivingBase)player), morph.getHeight((EntityLivingBase)player));
        } else {
            float height;
            float width;
            if (player.func_184613_cA()) {
                width = 0.6f;
                height = 0.6f;
            } else if (player.func_70608_bn()) {
                width = 0.2f;
                height = 0.2f;
            } else if (player.func_70093_af()) {
                width = 0.6f;
                height = 1.65f;
            } else {
                width = 0.6f;
                height = 1.8f;
            }
            AbstractMorph.updateSizeDefault((EntityLivingBase)player, width, height);
        }
    }

    public static boolean canPlayerMorphFit(EntityPlayer player, AbstractMorph currentMorph, AbstractMorph newMorph) {
        EntityUtils.forceUpdateSize(player, newMorph);
        boolean canFit = player.field_70170_p.func_147461_a(player.func_174813_aQ()).isEmpty();
        EntityUtils.forceUpdateSize(player, currentMorph);
        return canFit;
    }
}

