/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.api;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Map;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.abilities.IAbility;
import mchorse.metamorph.api.abilities.IAction;
import mchorse.metamorph.api.abilities.IAttackAbility;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class MorphSettings {
    public static final MorphSettings DEFAULT = new MorphSettings();
    public IAbility[] abilities = new IAbility[0];
    public IAttackAbility attack;
    public IAction action;
    public int health = 20;
    public float speed = 0.1f;
    public boolean hostile;
    public boolean hands;
    public boolean updates = true;

    public void merge(MorphSettings setting) {
        if (setting.abilities.length != 0) {
            ArrayList<IAbility> abilities = new ArrayList<IAbility>();
            for (IAbility ability : setting.abilities) {
                abilities.add(ability);
            }
            this.abilities = abilities.toArray(new IAbility[abilities.size()]);
        }
        this.action = setting.action;
        this.attack = setting.attack;
        this.health = setting.health;
        this.speed = setting.speed;
        this.hostile = setting.hostile;
        this.hands = setting.hands;
        this.updates = setting.updates;
    }

    public MorphSettings clone() {
        MorphSettings settings = new MorphSettings();
        settings.merge(this);
        return settings;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.abilities.length);
        for (IAbility ability : this.abilities) {
            String string = MorphSettings.getKey(MorphManager.INSTANCE.abilities, ability);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)(string == null ? "" : string));
        }
        String action = MorphSettings.getKey(MorphManager.INSTANCE.actions, this.action);
        String attack = MorphSettings.getKey(MorphManager.INSTANCE.attacks, this.attack);
        buf.writeBoolean(action != null);
        if (action != null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)action);
        }
        buf.writeBoolean(attack != null);
        if (attack != null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)attack);
        }
        buf.writeInt(this.health);
        buf.writeFloat(this.speed);
        buf.writeBoolean(this.hostile);
        buf.writeBoolean(this.hands);
        buf.writeBoolean(this.updates);
    }

    public void fromBytes(ByteBuf buf) {
        ArrayList<IAbility> abilities = new ArrayList<IAbility>();
        int c = buf.readInt();
        for (int i = 0; i < c; ++i) {
            IAbility ability = MorphManager.INSTANCE.abilities.get(ByteBufUtils.readUTF8String((ByteBuf)buf));
            if (ability == null) continue;
            abilities.add(ability);
        }
        this.abilities = abilities.toArray(new IAbility[abilities.size()]);
        if (buf.readBoolean()) {
            String action = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.action = MorphManager.INSTANCE.actions.get(action);
        }
        if (buf.readBoolean()) {
            String attack = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.attack = MorphManager.INSTANCE.attacks.get(attack);
        }
        this.health = buf.readInt();
        this.speed = buf.readFloat();
        this.hostile = buf.readBoolean();
        this.hands = buf.readBoolean();
        this.updates = buf.readBoolean();
    }

    public static <T> String getKey(Map<String, T> map, T value) {
        if (value == null) {
            return null;
        }
        for (Map.Entry<String, T> entry : map.entrySet()) {
            if (entry.getValue() != value) continue;
            return entry.getKey();
        }
        return null;
    }
}

