/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.api;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;
import mchorse.metamorph.api.MorphSettings;
import mchorse.metamorph.api.events.RegisterBlacklistEvent;
import mchorse.metamorph.api.events.RegisterSettingsEvent;
import mchorse.metamorph.api.morphs.AbstractMorph;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class MorphUtils {
    public static void generateFile(File config, String content) {
        config.getParentFile().mkdirs();
        try {
            PrintWriter writer = new PrintWriter(config);
            writer.print(content);
            writer.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static Set<String> reloadBlacklist() {
        RegisterBlacklistEvent event = new RegisterBlacklistEvent();
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.blacklist;
    }

    public static Map<String, MorphSettings> reloadMorphSettings() {
        RegisterSettingsEvent event = new RegisterSettingsEvent();
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.settings;
    }

    public static AbstractMorph clone(AbstractMorph morph, boolean isRemote) {
        return morph == null ? null : morph.clone(isRemote);
    }

    public static NBTTagCompound toNBT(AbstractMorph morph) {
        if (morph == null) {
            return null;
        }
        NBTTagCompound tag = new NBTTagCompound();
        morph.toNBT(tag);
        return tag;
    }
}

