/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.bodypart;

import java.util.ArrayList;
import java.util.List;
import mchorse.metamorph.bodypart.BodyPart;
import mchorse.metamorph.capabilities.morphing.IMorphing;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BodyPartManager {
    public List<BodyPart> parts = new ArrayList<BodyPart>();
    private boolean initiated;

    public void reset() {
        this.initiated = false;
    }

    @SideOnly(value=Side.CLIENT)
    public void reinitBodyParts() {
        this.reset();
        this.initBodyParts();
    }

    @SideOnly(value=Side.CLIENT)
    public void initBodyParts() {
        if (!this.initiated) {
            for (BodyPart part : this.parts) {
                part.init();
            }
            this.initiated = true;
        }
    }

    public void updateBodyLimbs(EntityLivingBase target, IMorphing cap) {
        for (BodyPart part : this.parts) {
            part.update(target, cap);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof BodyPartManager) {
            BodyPartManager manager = (BodyPartManager)obj;
            return this.parts.equals(manager.parts);
        }
        return super.equals(obj);
    }

    public void copy(BodyPartManager manager, boolean isRemote) {
        this.reset();
        this.parts.clear();
        for (BodyPart part : manager.parts) {
            this.parts.add(part.clone(isRemote));
        }
    }

    public void merge(BodyPartManager manager, boolean isRemote) {
        if (manager.parts.size() != this.parts.size()) {
            this.copy(manager, isRemote);
            return;
        }
        int c = this.parts.size();
        for (int i = 0; i < c; ++i) {
            BodyPart other;
            BodyPart part = this.parts.get(i);
            if (part.canMerge(other = manager.parts.get(i), isRemote)) continue;
            this.parts.set(i, other.clone(isRemote));
        }
    }

    public NBTTagList toNBT() {
        if (!this.parts.isEmpty()) {
            NBTTagList bodyParts = new NBTTagList();
            for (BodyPart part : this.parts) {
                NBTTagCompound bodyPart = new NBTTagCompound();
                part.toNBT(bodyPart);
                if (bodyPart.func_82582_d()) continue;
                bodyParts.func_74742_a((NBTBase)bodyPart);
            }
            return bodyParts;
        }
        return null;
    }

    public void fromNBT(NBTTagList bodyParts) {
        this.parts.clear();
        int c = bodyParts.func_74745_c();
        for (int i = 0; i < c; ++i) {
            NBTTagCompound bodyPart = bodyParts.func_150305_b(i);
            BodyPart part = new BodyPart();
            part.fromNBT(bodyPart);
            this.parts.add(part);
        }
    }
}

