/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.bodypart;

import mchorse.mclib.utils.DummyEntity;
import mchorse.mclib.utils.NBTUtils;
import mchorse.metamorph.api.Morph;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.bodypart.IBodyPart;
import mchorse.metamorph.capabilities.morphing.IMorphing;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class MorphBodyPart
implements IBodyPart {
    public Morph morph = new Morph();
    public ItemStack[] slots = new ItemStack[6];
    public float[] translate = new float[3];
    public float[] scale = new float[]{1.0f, 1.0f, 1.0f};
    public float[] rotate = new float[]{180.0f, 0.0f, 0.0f};
    public boolean useTarget = false;
    @SideOnly(value=Side.CLIENT)
    private EntityLivingBase entity;

    @Override
    @SideOnly(value=Side.CLIENT)
    public void init() {
        this.entity = new DummyEntity((World)Minecraft.func_71410_x().field_71441_e);
        this.entity.field_70177_z = this.entity.field_70126_B;
        this.entity.field_70759_as = this.entity.field_70758_at;
        this.entity.field_70122_E = true;
        this.updateEntity();
    }

    @SideOnly(value=Side.CLIENT)
    public void updateEntity() {
        if (this.entity == null) {
            return;
        }
        for (int i = 0; i < this.slots.length; ++i) {
            this.entity.func_184201_a(EntityEquipmentSlot.values()[i], this.slots[i]);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(EntityLivingBase entity, float partialTicks) {
        EntityLivingBase entityLivingBase = entity = this.useTarget ? entity : this.entity;
        if (this.morph.get() == null || entity == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.translate[0], (float)this.translate[1], (float)this.translate[2]);
        GL11.glRotatef((float)this.rotate[2], (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)this.rotate[1], (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)this.rotate[0], (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)this.scale[0], (float)this.scale[1], (float)this.scale[2]);
        float rotationYaw = entity.field_70761_aq;
        float prevRotationYaw = entity.field_70760_ar;
        float rotationYawHead = entity.field_70759_as;
        float prevRotationYawHead = entity.field_70758_at;
        entity.field_70759_as -= entity.field_70761_aq;
        entity.field_70758_at -= entity.field_70760_ar;
        entity.field_70760_ar = 0.0f;
        entity.field_70761_aq = 0.0f;
        this.morph.get().render(entity, 0.0, 0.0, 0.0, 0.0f, partialTicks);
        entity.field_70761_aq = rotationYaw;
        entity.field_70760_ar = prevRotationYaw;
        entity.field_70759_as = rotationYawHead;
        entity.field_70758_at = prevRotationYawHead;
        GL11.glPopMatrix();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void update(EntityLivingBase entity, IMorphing cap) {
        EntityLivingBase entityLivingBase = entity = this.useTarget ? entity : this.entity;
        if (entity != null) {
            AbstractMorph morph;
            if (!this.useTarget) {
                ++this.entity.field_70173_aa;
            }
            if ((morph = this.morph.get()) != null) {
                float rotationYaw = entity.field_70761_aq;
                float prevRotationYaw = entity.field_70760_ar;
                float rotationYawHead = entity.field_70759_as;
                float prevRotationYawHead = entity.field_70758_at;
                entity.field_70759_as -= entity.field_70761_aq;
                entity.field_70758_at -= entity.field_70760_ar;
                entity.field_70760_ar = 0.0f;
                entity.field_70761_aq = 0.0f;
                morph.update(entity, cap);
                entity.field_70761_aq = rotationYaw;
                entity.field_70760_ar = prevRotationYaw;
                entity.field_70759_as = rotationYawHead;
                entity.field_70758_at = prevRotationYawHead;
            }
        }
    }

    @Override
    public boolean canMerge(IBodyPart part, boolean isRemote) {
        if (part instanceof MorphBodyPart) {
            MorphBodyPart morph = (MorphBodyPart)part;
            this.morph.copy(morph.morph, isRemote);
            this.translate[0] = morph.translate[0];
            this.translate[1] = morph.translate[1];
            this.translate[2] = morph.translate[2];
            this.scale[0] = morph.scale[0];
            this.scale[1] = morph.scale[1];
            this.scale[2] = morph.scale[2];
            this.rotate[0] = morph.rotate[0];
            this.rotate[1] = morph.rotate[1];
            this.rotate[2] = morph.rotate[2];
            this.useTarget = morph.useTarget;
            for (int i = 0; i < morph.slots.length; ++i) {
                this.slots[i] = morph.slots[i];
            }
            return true;
        }
        return false;
    }

    public MorphBodyPart clone(boolean isRemote) {
        MorphBodyPart part = new MorphBodyPart();
        part.morph.copy(this.morph, isRemote);
        part.translate[0] = this.translate[0];
        part.translate[1] = this.translate[1];
        part.translate[2] = this.translate[2];
        part.scale[0] = this.scale[0];
        part.scale[1] = this.scale[1];
        part.scale[2] = this.scale[2];
        part.rotate[0] = this.rotate[0];
        part.rotate[1] = this.rotate[1];
        part.rotate[2] = this.rotate[2];
        part.useTarget = this.useTarget;
        for (int i = 0; i < this.slots.length; ++i) {
            part.slots[i] = this.slots[i];
        }
        return part;
    }

    @Override
    public void fromNBT(NBTTagCompound tag) {
        if (tag.func_150297_b("Morph", 10)) {
            this.morph.fromNBT(tag.func_74775_l("Morph"));
        }
        if (tag.func_150297_b("Items", 9)) {
            NBTTagList items = tag.func_150295_c("Items", 10);
            int c = items.func_74745_c();
            for (int i = 0; i < c; ++i) {
                ItemStack stack;
                NBTTagCompound compound = items.func_150305_b(i);
                this.slots[i] = stack = ItemStack.func_77949_a((NBTTagCompound)compound);
            }
        }
        NBTUtils.readFloatList((NBTTagList)tag.func_150295_c("T", 5), (float[])this.translate);
        NBTUtils.readFloatList((NBTTagList)tag.func_150295_c("S", 5), (float[])this.scale);
        NBTUtils.readFloatList((NBTTagList)tag.func_150295_c("R", 5), (float[])this.rotate);
        if (tag.func_74764_b("Target")) {
            this.useTarget = tag.func_74767_n("Target");
        }
    }

    @Override
    public void toNBT(NBTTagCompound tag) {
        NBTTagCompound morph = this.morph.toNBT();
        if (morph != null) {
            tag.func_74782_a("Morph", (NBTBase)morph);
        }
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            NBTTagCompound compound = new NBTTagCompound();
            ItemStack stack = this.slots[i];
            if (stack != null) {
                stack.func_77955_b(compound);
            }
            list.func_74742_a((NBTBase)compound);
        }
        tag.func_74782_a("Items", (NBTBase)list);
        if (this.translate[0] != 0.0f || this.translate[1] != 0.0f || this.translate[2] != 0.0f) {
            tag.func_74782_a("T", (NBTBase)NBTUtils.writeFloatList((NBTTagList)new NBTTagList(), (float[])this.translate));
        }
        if (this.scale[0] != 1.0f || this.scale[1] != 1.0f || this.scale[2] != 1.0f) {
            tag.func_74782_a("S", (NBTBase)NBTUtils.writeFloatList((NBTTagList)new NBTTagList(), (float[])this.scale));
        }
        if (this.rotate[0] != 180.0f || this.rotate[1] != 0.0f || this.rotate[2] != 0.0f) {
            tag.func_74782_a("R", (NBTBase)NBTUtils.writeFloatList((NBTTagList)new NBTTagList(), (float[])this.rotate));
        }
        if (this.useTarget) {
            tag.func_74757_a("Target", this.useTarget);
        }
    }
}

