/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.client.gui.elements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import mchorse.mclib.client.gui.framework.GuiTooltip;
import mchorse.mclib.client.gui.framework.elements.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.GuiDelegateElement;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.GuiTextElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.utils.GuiUtils;
import mchorse.mclib.client.gui.utils.Resizer;
import mchorse.mclib.client.gui.utils.ScrollArea;
import mchorse.metamorph.api.MorphList;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.events.ReloadMorphs;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.capabilities.morphing.IMorphing;
import mchorse.metamorph.client.gui.editor.GuiAbstractMorph;
import mchorse.metamorph.client.gui.elements.GuiCreativeVariantPicker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.lwjgl.opengl.GL11;

public class GuiCreativeMorphs
extends GuiElement {
    public static final int CELL_HEIGHT = 60;
    private int perRow;
    private int selected = -1;
    private int selectedMorph = -1;
    private String previousFilter = "";
    private List<MorphCategory> categories = new ArrayList<MorphCategory>();
    private MorphCategory acquired;
    private MorphCell selectedCell;
    public ScrollArea scroll = new ScrollArea(60);
    public Consumer<AbstractMorph> callback;
    public int shiftX = 0;
    private List<GuiAbstractMorph> editors;
    private GuiCreativeVariantPicker picker;
    public GuiDelegateElement<GuiAbstractMorph> editor;
    public GuiButtonElement<GuiButton> top;
    public GuiButtonElement<GuiButton> edit;
    public GuiTextElement search;

    public GuiCreativeMorphs(Minecraft mc, int perRow, AbstractMorph selected, IMorphing morphing) {
        super(mc);
        MinecraftForge.EVENT_BUS.post((Event)new ReloadMorphs());
        this.perRow = perRow;
        this.compileCategories(morphing);
        this.initiateCategories(selected, true);
        this.picker = new GuiCreativeVariantPicker(mc, this);
        this.picker.resizer().parent(this.area).set(0.0f, 0.0f, 0.0f, 60.0f).w(1.0f, 0).y(1.0f, -60);
        this.editor = new GuiDelegateElement(mc, null);
        this.editor.resizer().parent(this.area).set(0.0f, 0.0f, 1.0f, 1.0f, Resizer.Measure.RELATIVE);
        this.createChildren();
        this.top = GuiButtonElement.button((Minecraft)mc, (String)"^", b -> this.scroll.scrollTo(0));
        this.edit = GuiButtonElement.button((Minecraft)mc, (String)I18n.func_135052_a((String)"metamorph.gui.edit", (Object[])new Object[0]), b -> this.toggleEditMode());
        this.search = new GuiTextElement(mc, filter -> this.setFilter((String)filter));
        this.search.field.func_146195_b(true);
        this.edit.resizer().parent(this.area).set(0.0f, 10.0f, 55.0f, 20.0f).x(1.0f, -90);
        this.top.resizer().relative(this.edit.resizer()).set(60.0f, 0.0f, 20.0f, 20.0f);
        this.search.resizer().parent(this.area).set(10.0f, 10.0f, 0.0f, 20.0f).w(1.0f, -105);
        this.children.add(new IGuiElement[]{this.picker, this.edit, this.search, this.top, this.editor});
        this.scroll.scrollSpeed = 40;
    }

    public GuiCreativeMorphs(Minecraft mc, int perRow, AbstractMorph selected) {
        this(mc, perRow, selected, null);
    }

    public void resize(int width, int height) {
        super.resize(width, height);
        this.scroll.copy(this.area);
    }

    public boolean isEditMode() {
        return this.editor.delegate != null;
    }

    public void toggleEditMode() {
        MorphCell cell = this.getSelected();
        if (cell == null) {
            return;
        }
        AbstractMorph morph = cell.current().morph;
        if (!this.isEditMode()) {
            if (morph != null) {
                morph = morph.clone(true);
            }
            GuiAbstractMorph editor = this.getMorphEditor(morph);
            editor.finish.callback = this.getToggleCallback();
            if (editor != null) {
                this.editor.setDelegate((IGuiElement)editor);
                this.setSelected(morph, false, false);
                this.setMorph(morph);
            }
        } else {
            ((GuiAbstractMorph)this.editor.delegate).finishEdit();
            this.editor.setDelegate(null);
            this.setMorph(morph);
        }
        boolean hide = this.editor.delegate == null;
        this.picker.setVisible(hide);
        this.search.setVisible(hide);
        this.top.setVisible(hide);
        this.edit.setVisible(hide);
    }

    public void finish() {
        if (this.isEditMode()) {
            ((GuiAbstractMorph)this.editor.delegate).finishEdit();
        }
    }

    protected Consumer<GuiButtonElement<GuiButton>> getToggleCallback() {
        return this.edit.callback;
    }

    private GuiAbstractMorph getMorphEditor(AbstractMorph morph) {
        if (this.editors == null) {
            this.editors = new ArrayList<GuiAbstractMorph>();
            MorphManager.INSTANCE.registerMorphEditors(this.editors);
        }
        for (GuiAbstractMorph editor : this.editors) {
            if (!editor.canEdit(morph)) continue;
            editor.startEdit(morph);
            return editor;
        }
        return null;
    }

    protected void compileCategories(IMorphing morphing) {
        HashMap<String, MorphCategory> categories = new HashMap<String, MorphCategory>();
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        for (List<MorphList.MorphCell> morphs : MorphManager.INSTANCE.getMorphs((World)world).morphs.values()) {
            if (morphs.size() == 0) continue;
            MorphCell cell = new MorphCell();
            String name = morphs.get((int)0).category;
            String variant = morphs.get((int)0).categoryVariant;
            String key = name + "#" + variant;
            for (MorphList.MorphCell morph : morphs) {
                String morphVariant = morph.variant.isEmpty() ? morph.variant : " (" + morph.variant + ")";
                String title = MorphManager.INSTANCE.morphDisplayNameFromMorph(morph.morph) + morphVariant;
                cell.variants.add(new MorphVariant(title, morph.morph));
            }
            MorphCategory category = (MorphCategory)categories.get(key);
            if (category == null) {
                category = new MorphCategory(name, key, variant);
                categories.put(key, category);
            }
            category.cells.add(cell);
        }
        this.categories.addAll(categories.values());
        Collections.sort(this.categories, new Comparator<MorphCategory>(){

            @Override
            public int compare(MorphCategory a, MorphCategory b) {
                return a.title.compareTo(b.title);
            }
        });
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Name", "metamorph.Block");
        tag.func_74778_a("Block", "minecraft:stone");
        this.acquired = new MorphCategory("acquired", "acquired", "");
        this.selectedCell = new MorphCell();
        this.acquired.cells.add(this.selectedCell);
        this.selectedCell.variants.add(new MorphVariant("Selected", MorphManager.INSTANCE.morphFromNBT(tag)));
        this.categories.add(0, this.acquired);
        if (morphing != null) {
            for (AbstractMorph morph : morphing.getAcquiredMorphs()) {
                this.acquired.cells.add(new MorphCell(MorphManager.INSTANCE.morphDisplayNameFromMorph(morph), morph.clone(true)));
            }
        }
    }

    protected void initiateCategories(AbstractMorph morph, boolean compare) {
        int i = 0;
        int y = 0;
        int selectedCat = -1;
        int selectedMorph = -1;
        this.scroll.scrollSize = 30;
        for (MorphCategory category : this.categories) {
            int j = 0;
            Collections.sort(category.cells, new Comparator<MorphCell>(){

                @Override
                public int compare(MorphCell a, MorphCell b) {
                    return a.current().name.compareTo(b.current().name);
                }
            });
            category.height = MathHelper.func_76123_f((float)((float)category.cells.size() / (float)this.perRow));
            category.y = this.scroll.scrollSize + 10;
            this.scroll.scrollSize += category.height * 60 + 40;
            for (MorphCell cell : category.cells) {
                Collections.sort(cell.variants, new Comparator<MorphVariant>(){

                    @Override
                    public int compare(MorphVariant a, MorphVariant b) {
                        return a.name.compareTo(b.name);
                    }
                });
                if (selectedCat == -1 && morph != null && cell.hasMorph(morph) && compare) {
                    selectedCat = i;
                    selectedMorph = j;
                    y = category.y + j / this.perRow * 60;
                }
                cell.index = j++;
                cell.hasVisible = true;
            }
            ++i;
        }
        this.scroll.scrollSize -= 10;
        this.scroll.scrollTo(y - 40);
        this.selected = selectedCat;
        this.selectedMorph = selectedMorph;
        if ((selectedCat == -1 || selectedMorph == -1) && morph != null) {
            this.selected = 0;
            this.selectedMorph = this.selectedCell.index;
            this.scroll.scrollTo(0);
            this.selectedCell.variants.clear();
            this.selectedCell.variants.add(new MorphVariant(I18n.func_135052_a((String)"metamorph.gui.selected", (Object[])new Object[0]), compare ? morph.clone(true) : morph));
            this.selectedCell.selected = 0;
        }
    }

    public void setPerRow(int perRow) {
        MorphCell selected = this.getSelected();
        this.perRow = perRow;
        this.initiateCategories(selected != null ? selected.current().morph : null, true);
    }

    public void setFilter(String filter) {
        this.setFilter(filter, true);
    }

    public void setFilter(String filter, boolean select) {
        if (filter.equals(this.previousFilter)) {
            return;
        }
        String lcfilter = filter.toLowerCase();
        this.scroll.scroll = 0;
        this.scroll.scrollSize = 30;
        this.previousFilter = filter;
        for (MorphCategory cat : this.categories) {
            int i = 0;
            for (MorphCell cell : cat.cells) {
                boolean selected = false;
                int j = 0;
                cell.hasVisible = false;
                for (MorphVariant variant : cell.variants) {
                    boolean bl = filter.isEmpty() ? false : (variant.hidden = variant.name.toLowerCase().indexOf(lcfilter) == -1 && variant.morph.name.toLowerCase().indexOf(lcfilter) == -1);
                    if (!variant.hidden) {
                        if (!selected && select) {
                            cell.selected = j;
                            selected = true;
                        }
                        cell.hasVisible = true;
                    }
                    ++j;
                }
                if (!cell.hasVisible) continue;
                ++i;
            }
            cat.height = MathHelper.func_76123_f((float)((float)i / (float)this.perRow));
            cat.y = this.scroll.scrollSize + 10;
            this.scroll.scrollSize = this.scroll.scrollSize + (i == 0 ? 0 : cat.height * 60 + 40);
        }
    }

    public void setSelected(AbstractMorph morph) {
        this.setSelected(morph, true, true);
    }

    public void setSelected(AbstractMorph morph, boolean restore, boolean compare) {
        String prevFilter;
        this.initiateCategories(morph, compare);
        if (restore && !(prevFilter = this.previousFilter).isEmpty()) {
            this.previousFilter = "";
            this.setFilter(prevFilter, false);
        }
    }

    public MorphCell getSelected() {
        if (this.selected >= 0 && this.selected < this.categories.size()) {
            MorphCategory category = this.categories.get(this.selected);
            if (this.selectedMorph >= 0 && this.selectedMorph < category.cells.size()) {
                MorphCell cell = category.cells.get(this.selectedMorph);
                if (!cell.variants.isEmpty()) {
                    return cell;
                }
            }
        }
        return null;
    }

    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (this.scroll.mouseClicked(mouseX, mouseY) || super.mouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (!this.area.isInside(mouseX, mouseY) || this.isEditMode() || this.search.field.func_146206_l()) {
            return false;
        }
        int y = mouseY - this.scroll.y + this.scroll.scroll - 10;
        int x = (mouseX - this.scroll.x) / (this.scroll.w / this.perRow);
        int i = 0;
        MorphCategory cat = null;
        for (MorphCategory category : this.categories) {
            if (y >= category.y && y < category.y + category.height * 60) {
                cat = category;
                break;
            }
            ++i;
        }
        if (cat != null) {
            y = (y - cat.y) / 60;
            this.selected = i;
            this.selectedMorph = -1;
            int j = 0;
            int index = x + y * this.perRow;
            for (MorphCell cell : cat.cells) {
                if (!cell.hasVisible) continue;
                if (j == index) {
                    this.selectedMorph = cell.index;
                    this.setMorph(this.getSelected().current().morph);
                    break;
                }
                ++j;
            }
            if (this.selectedMorph == -1) {
                this.setMorph(null);
            }
        } else {
            this.selected = -1;
            this.selectedMorph = -1;
            this.setMorph(null);
        }
        return true;
    }

    public void setMorph(AbstractMorph morph) {
        if (this.callback != null) {
            this.callback.accept(morph);
        }
    }

    public boolean mouseScrolled(int mouseX, int mouseY, int scroll) {
        return super.mouseScrolled(mouseX, mouseY, scroll) || this.scroll.mouseScroll(mouseX, mouseY, scroll);
    }

    public void mouseReleased(int mouseX, int mouseY, int state) {
        super.mouseReleased(mouseX, mouseY, state);
        this.scroll.mouseReleased(mouseX, mouseY);
    }

    public void keyTyped(char typedChar, int keyCode) {
        super.keyTyped(typedChar, keyCode);
        if (!this.isEditMode()) {
            if (keyCode == 208) {
                this.scroll.scrollBy(30);
            } else if (keyCode == 200) {
                this.scroll.scrollBy(-30);
            } else if (keyCode == 203) {
                this.scroll.scrollTo(0);
            } else if (keyCode == 205) {
                this.scroll.scrollTo(this.scroll.scrollSize);
            }
        }
    }

    public void draw(GuiTooltip tooltip, int mouseX, int mouseY, float partialTicks) {
        if (!this.isEditMode()) {
            GuiScreen screen = this.mc.field_71462_r;
            this.scroll.drag(mouseX, mouseY);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)(-this.scroll.scroll), (float)0.0f);
            GuiUtils.scissor((int)this.scroll.x, (int)this.scroll.y, (int)this.scroll.w, (int)this.scroll.h, (int)screen.field_146294_l, (int)screen.field_146295_m);
            this.drawMorphs(mouseX, mouseY);
            GL11.glDisable((int)3089);
            GL11.glPopMatrix();
            this.scroll.drawScrollbar();
        }
        super.draw(tooltip, mouseX, mouseY, partialTicks);
        if (!this.isEditMode() && !this.search.field.func_146206_l() && this.search.field.func_146179_b().isEmpty()) {
            this.font.func_175063_a(I18n.func_135052_a((String)"metamorph.gui.search", (Object[])new Object[0]), (float)(this.search.area.x + 5), (float)(this.search.area.y + 6), 0x888888);
        }
    }

    private void drawMorphs(int mouseX, int mouseY) {
        int m = this.scroll.w / this.perRow;
        int j = 0;
        for (MorphCategory category : this.categories) {
            int h = (MathHelper.func_76123_f((float)(category.cells.size() / this.perRow)) + 1) * 60;
            if (category.height == 0 || category.y < this.scroll.scroll - h || category.y > this.scroll.scroll + this.scroll.h) {
                ++j;
                continue;
            }
            int k = 0;
            this.func_73731_b(this.font, category.title, this.scroll.x + this.shiftX + 1, category.y + this.scroll.y, -1);
            for (MorphCell cell : category.cells) {
                int x = k % this.perRow * m + this.scroll.x;
                int y = k / this.perRow * 60 + category.y + this.scroll.y;
                boolean insidePicker = this.picker.isActive() && mouseY >= this.scroll.y + this.scroll.h - 60;
                boolean hover = mouseX >= x && mouseY + this.scroll.scroll >= y && mouseX < x + m && mouseY + this.scroll.scroll < y + 60 && !insidePicker;
                MorphVariant variant = cell.current();
                if (!cell.hasVisible) continue;
                if (y < this.scroll.scroll - 15) {
                    ++k;
                    continue;
                }
                float scale = hover ? 28.0f : 21.5f;
                variant.render((EntityPlayer)Minecraft.func_71410_x().field_71439_g, x + m / 2, y + 50, scale);
                if (j == this.selected && cell.index == this.selectedMorph) {
                    this.renderSelected(x + 1, y + 10, m - 2, 60, variant.error);
                }
                ++k;
            }
            ++j;
        }
    }

    private void renderSelected(int x, int y, int width, int height, boolean error) {
        int color = error ? -65536 : -3355444;
        this.func_73730_a(x, x + width - 1, y, color);
        this.func_73730_a(x, x + width - 1, y + height - 1, color);
        this.func_73728_b(x, y, y + height - 1, color);
        this.func_73728_b(x + width - 1, y, y + height - 1, color);
    }

    public static class MorphVariant {
        public String name;
        public AbstractMorph morph;
        public boolean hidden = false;
        public boolean first = true;
        public boolean error = false;

        public MorphVariant(String name, AbstractMorph morph) {
            this.name = name;
            this.morph = morph;
        }

        public void render(EntityPlayer player, int x, int y, float scale) {
            if (this.first) {
                try {
                    this.morph.renderOnScreen(player, x, y, scale, 1.0f);
                }
                catch (Exception e) {
                    String name = this.morph != null ? this.morph.name : "unknown";
                    System.out.println("Failed to render morph by name " + name + "!");
                    e.printStackTrace();
                    this.error = true;
                }
                this.first = false;
            } else if (!this.error) {
                this.morph.renderOnScreen(player, x, y, scale, 1.0f);
            }
        }
    }

    public static class MorphCell {
        public List<MorphVariant> variants = new ArrayList<MorphVariant>();
        public int index;
        public int selected;
        public boolean hasVisible = true;

        public MorphCell() {
        }

        public MorphCell(String name, AbstractMorph morph) {
            this();
            this.variants.add(new MorphVariant(name, morph));
        }

        public boolean hasMorph(AbstractMorph morph) {
            int c = this.variants.size();
            for (int i = 0; i < c; ++i) {
                MorphVariant variant = this.variants.get(i);
                if (!variant.morph.equals(morph)) continue;
                this.selected = i;
                return true;
            }
            return false;
        }

        public MorphVariant current() {
            return this.variants.get(this.selected);
        }
    }

    public static class MorphCategory {
        public static final String KEY = "morph.category.";
        public List<MorphCell> cells = new ArrayList<MorphCell>();
        public String title;
        public String key;
        public int height;
        public int y;

        public MorphCategory(String title, String key, String variant) {
            String result = I18n.func_135052_a((String)(KEY + title), (Object[])new Object[0]);
            if (title.isEmpty()) {
                result = I18n.func_135052_a((String)"morph.category.unknown", (Object[])new Object[0]);
            } else if (result.equals(KEY + title)) {
                result = I18n.func_135052_a((String)"morph.category.modded", (Object[])new Object[]{title});
            }
            this.title = result;
            this.key = key;
            if (!variant.isEmpty()) {
                this.title = this.title + " (" + variant + ")";
            }
        }
    }
}

