/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.client.gui.elements;

import mchorse.mclib.client.gui.framework.GuiTooltip;
import mchorse.mclib.client.gui.framework.elements.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.capabilities.morphing.IMorphing;
import mchorse.metamorph.client.gui.elements.GuiCreativeMorphs;
import mchorse.metamorph.network.Dispatcher;
import mchorse.metamorph.network.common.PacketAcquireMorph;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import org.lwjgl.opengl.GL11;

public class GuiCreativeMorphsMenu
extends GuiCreativeMorphs {
    private GuiButtonElement<GuiButton> close;
    private GuiButtonElement<GuiButton> acquire;

    public GuiCreativeMorphsMenu(Minecraft mc, int perRow, AbstractMorph selected, IMorphing morphing) {
        super(mc, perRow, selected, morphing);
        this.acquire = GuiButtonElement.button((Minecraft)mc, (String)I18n.func_135052_a((String)"metamorph.gui.acquire", (Object[])new Object[0]), b -> {
            GuiCreativeMorphs.MorphCell cell = this.getSelected();
            if (cell != null) {
                Dispatcher.sendToServer(new PacketAcquireMorph(cell.current().morph));
            }
        });
        this.close = GuiButtonElement.button((Minecraft)mc, (String)"X", b -> {
            if (this.isEditMode()) {
                this.setMorph(this.getSelected().current().morph);
            }
            this.setVisible(false);
        });
        this.acquire.resizer().parent(this.area).set(10.0f, 10.0f, 60.0f, 20.0f);
        this.close.resizer().parent(this.area).set(0.0f, 10.0f, 20.0f, 20.0f).x(1.0f, -30);
        this.edit.resizer().x(1.0f, -115);
        this.children.add(new IGuiElement[]{this.acquire, this.close});
        this.search.resizer().set(75.0f, 10.0f, 0.0f, 20.0f).w(1.0f, -195);
        this.setVisible(false);
        this.shiftX = 8;
    }

    @Override
    public void resize(int width, int height) {
        super.resize(width, height);
        int perRow = (int)Math.ceil((float)this.area.w / 50.0f);
        this.setPerRow(perRow == 0 ? 1 : perRow);
    }

    @Override
    public void setSelected(AbstractMorph morph) {
        super.setSelected(morph);
        GuiCreativeMorphs.MorphCell cell = this.getSelected();
        this.setMorph(cell == null ? null : cell.current().morph);
    }

    @Override
    public void toggleEditMode() {
        super.toggleEditMode();
        this.acquire.setVisible(this.editor.delegate == null);
        this.close.setVisible(this.editor.delegate == null);
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        return super.mouseClicked(mouseX, mouseY, mouseButton) || this.area.isInside(mouseX, mouseY);
    }

    @Override
    public boolean mouseScrolled(int mouseX, int mouseY, int scroll) {
        return super.mouseScrolled(mouseX, mouseY, scroll) || this.area.isInside(mouseX, mouseY);
    }

    @Override
    public void draw(GuiTooltip tooltip, int mouseX, int mouseY, float partialTicks) {
        tooltip.set(null, null);
        GL11.glClear((int)256);
        Gui.func_73734_a((int)this.area.x, (int)this.area.y, (int)this.area.getX(1.0f), (int)this.area.getY(1.0f), (int)-1442840576);
        GuiCreativeMorphs.MorphCell cell = this.getSelected();
        if (cell != null && !this.isEditMode()) {
            int width = Math.max(this.font.func_78256_a(cell.current().name), this.font.func_78256_a(cell.current().morph.name)) + 6;
            int center = this.area.getX(0.5f);
            int y = this.area.y + 40;
            Gui.func_73734_a((int)(center - width / 2), (int)(y - 4), (int)(center + width / 2), (int)(y + 24), (int)-2013265920);
            this.func_73732_a(this.font, cell.current().name, center, y, 0xFFFFFF);
            this.func_73732_a(this.font, cell.current().morph.name, center, y + 14, 0x888888);
        }
        super.draw(tooltip, mouseX, mouseY, partialTicks);
    }
}

