/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.client.gui.elements;

import mchorse.mclib.client.gui.framework.GuiTooltip;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.utils.GuiUtils;
import mchorse.mclib.client.gui.utils.ScrollArea;
import mchorse.metamorph.client.gui.elements.GuiCreativeMorphs;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.opengl.GL11;

public class GuiCreativeVariantPicker
extends GuiElement {
    public GuiCreativeMorphs morphs;
    public GuiCreativeMorphs.MorphCell previous;
    public ScrollArea scroll = new ScrollArea(40);

    public GuiCreativeVariantPicker(Minecraft mc, GuiCreativeMorphs morphs) {
        super(mc);
        this.morphs = morphs;
        this.scroll.direction = ScrollArea.ScrollDirection.HORIZONTAL;
        this.scroll.scrollSpeed = 5;
    }

    public void resize(int width, int height) {
        super.resize(width, height);
        this.scroll.copy(this.area);
    }

    public boolean isActive() {
        GuiCreativeMorphs.MorphCell selected = this.morphs.getSelected();
        if (this.previous != selected) {
            this.scroll.scroll = 0;
            if (selected != null) {
                int size = selected.variants.size();
                int index = 0;
                if (size > 1) {
                    for (int i = 0; i < size && i != selected.selected; ++i) {
                        index += selected.variants.get((int)i).hidden ? 0 : 1;
                    }
                    this.scroll.scroll = index * 40;
                }
            }
        }
        this.previous = selected;
        return selected != null && selected.variants.size() > 1;
    }

    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (this.scroll.mouseClicked(mouseX, mouseY)) {
            return true;
        }
        if (!this.scroll.isInside(mouseX, mouseY) || !this.isActive()) {
            return false;
        }
        GuiCreativeMorphs.MorphCell selected = this.morphs.getSelected();
        int index = (mouseX - this.scroll.x + this.scroll.scroll) / 40;
        int i = 0;
        int j = 0;
        for (GuiCreativeMorphs.MorphVariant variant : selected.variants) {
            if (!variant.hidden) {
                if (i == index) {
                    selected.selected = j;
                    this.morphs.setMorph(this.morphs.getSelected().current().morph);
                    break;
                }
                ++i;
            }
            ++j;
        }
        return true;
    }

    public boolean mouseScrolled(int mouseX, int mouseY, int scroll) {
        if (this.isActive()) {
            return this.scroll.mouseScroll(mouseX, mouseY, scroll);
        }
        return super.mouseScrolled(mouseX, mouseY, scroll);
    }

    public void mouseReleased(int mouseX, int mouseY, int state) {
        this.scroll.mouseReleased(mouseX, mouseY);
    }

    public void draw(GuiTooltip tooltip, int mouseX, int mouseY, float partialTicks) {
        if (!this.isActive()) {
            return;
        }
        GuiCreativeMorphs.MorphCell selected = this.morphs.getSelected();
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        GuiScreen screen = mc.field_71462_r;
        if (selected != null && selected.hasVisible) {
            int w = this.scroll.w;
            int h = this.scroll.h;
            int x = this.scroll.x;
            int y = this.scroll.y;
            int i = 0;
            int j = 0;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)200.0f);
            Gui.func_73734_a((int)x, (int)y, (int)(x + w), (int)(y + h), (int)-1442840576);
            GuiUtils.scissor((int)x, (int)y, (int)w, (int)h, (int)screen.field_146294_l, (int)screen.field_146295_m);
            for (GuiCreativeMorphs.MorphVariant variant : selected.variants) {
                boolean variantSelected = j == selected.selected;
                x = this.scroll.x + i * 40 - this.scroll.scroll;
                ++j;
                if (variant.hidden) continue;
                ++i;
                if (x < this.scroll.x - 40 || x >= this.scroll.x + this.scroll.w) continue;
                variant.morph.renderOnScreen((EntityPlayer)player, x + 20, y + (variantSelected ? 42 : 40), variantSelected ? 24.0f : 18.0f, 1.0f);
                if (!variantSelected) continue;
                Gui.func_73734_a((int)x, (int)y, (int)(x + 40), (int)(y + 2), (int)-1426063361);
            }
            GL11.glDisable((int)3089);
            GlStateManager.func_179121_F();
            this.scroll.scrollSize = i * 40;
            this.scroll.clamp();
            this.scroll.drag(mouseX, mouseY);
            this.scroll.drawScrollbar();
        }
    }
}

