/*
 * Decompiled with CFR 0.152.
 */
package mchorse.vanilla_pack;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import mchorse.metamorph.Metamorph;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.MorphSettings;
import mchorse.metamorph.api.abilities.IAbility;
import mchorse.metamorph.api.abilities.IAction;
import mchorse.metamorph.api.abilities.IAttackAbility;
import mchorse.metamorph.api.events.RegisterBlacklistEvent;
import mchorse.metamorph.api.events.RegisterSettingsEvent;
import mchorse.metamorph.api.json.MorphSettingsAdapter;
import mchorse.vanilla_pack.abilities.Climb;
import mchorse.vanilla_pack.abilities.FireProof;
import mchorse.vanilla_pack.abilities.Fly;
import mchorse.vanilla_pack.abilities.Glide;
import mchorse.vanilla_pack.abilities.Hungerless;
import mchorse.vanilla_pack.abilities.Jumping;
import mchorse.vanilla_pack.abilities.NightVision;
import mchorse.vanilla_pack.abilities.PreventFall;
import mchorse.vanilla_pack.abilities.SnowWalk;
import mchorse.vanilla_pack.abilities.SunAllergy;
import mchorse.vanilla_pack.abilities.Swim;
import mchorse.vanilla_pack.abilities.WaterAllergy;
import mchorse.vanilla_pack.abilities.WaterBreath;
import mchorse.vanilla_pack.actions.Endermite;
import mchorse.vanilla_pack.actions.Explode;
import mchorse.vanilla_pack.actions.FireBreath;
import mchorse.vanilla_pack.actions.Fireball;
import mchorse.vanilla_pack.actions.Jump;
import mchorse.vanilla_pack.actions.Potions;
import mchorse.vanilla_pack.actions.ShulkerBullet;
import mchorse.vanilla_pack.actions.Sliverfish;
import mchorse.vanilla_pack.actions.SmallFireball;
import mchorse.vanilla_pack.actions.Snowball;
import mchorse.vanilla_pack.actions.Teleport;
import mchorse.vanilla_pack.attacks.KnockbackAttack;
import mchorse.vanilla_pack.attacks.PoisonAttack;
import mchorse.vanilla_pack.attacks.WitherAttack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RegisterHandler {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(MorphSettings.class, (Object)new MorphSettingsAdapter()).create();

    public static void registerAbilities(MorphManager manager) {
        Map<String, IAbility> abilities = manager.abilities;
        Map<String, IAttackAbility> attacks = manager.attacks;
        Map<String, IAction> actions = manager.actions;
        abilities.put("climb", new Climb());
        abilities.put("fire_proof", new FireProof());
        abilities.put("fly", new Fly());
        abilities.put("glide", new Glide());
        abilities.put("hungerless", new Hungerless());
        abilities.put("jumping", new Jumping());
        abilities.put("night_vision", new NightVision());
        abilities.put("prevent_fall", new PreventFall());
        abilities.put("snow_walk", new SnowWalk());
        abilities.put("sun_allergy", new SunAllergy());
        abilities.put("swim", new Swim());
        abilities.put("water_allergy", new WaterAllergy());
        abilities.put("water_breath", new WaterBreath());
        actions.put("endermite", new Endermite());
        actions.put("explode", new Explode());
        actions.put("fireball", new Fireball());
        actions.put("fire_breath", new FireBreath());
        actions.put("jump", new Jump());
        actions.put("potions", new Potions());
        actions.put("shulker_bullet", new ShulkerBullet());
        actions.put("silverfish", new Sliverfish());
        actions.put("small_fireball", new SmallFireball());
        actions.put("snowball", new Snowball());
        actions.put("teleport", new Teleport());
        attacks.put("poison", new PoisonAttack());
        attacks.put("wither", new WitherAttack());
        attacks.put("knockback", new KnockbackAttack());
    }

    @SubscribeEvent
    public void onSettingsReload(RegisterSettingsEvent event) {
        this.loadMorphSettings(event.settings, this.getClass().getClassLoader().getResourceAsStream("assets/metamorph/morphs.json"));
        this.loadMorphSettings(event.settings, Metamorph.proxy.morphs);
    }

    private void loadMorphSettings(Map<String, MorphSettings> settings, File config) {
        try {
            this.loadMorphSettings(settings, new FileInputStream(config));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadMorphSettings(Map<String, MorphSettings> settings, InputStream input) {
        Scanner scanner = new Scanner(input, "UTF-8");
        Type type = new TypeToken<Map<String, MorphSettings>>(){}.getType();
        Map data = (Map)GSON.fromJson(scanner.useDelimiter("\\A").next(), type);
        scanner.close();
        for (Map.Entry entry : data.entrySet()) {
            String key = (String)entry.getKey();
            MorphSettings morphSettings = (MorphSettings)entry.getValue();
            if (settings.containsKey(key)) {
                settings.get(key).merge(morphSettings);
                continue;
            }
            settings.put(key, morphSettings);
        }
    }

    @SubscribeEvent
    public void onRegisterBlacklist(RegisterBlacklistEvent event) {
        event.blacklist.add("metamorph.Morph");
        this.loadBlacklist(event.blacklist, Metamorph.proxy.blacklist);
    }

    private void loadBlacklist(Set<String> set, File blacklist) {
        try {
            Scanner scanner = new Scanner((InputStream)new FileInputStream(blacklist), "UTF-8");
            Type type = new TypeToken<List<String>>(){}.getType();
            List data = (List)GSON.fromJson(scanner.useDelimiter("\\A").next(), type);
            set.addAll(data);
            scanner.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

