/*
 * Decompiled with CFR 0.152.
 */
package mchorse.vanilla_pack.morphs;

import com.google.common.base.Objects;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.capabilities.morphing.IMorphing;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMorph
extends AbstractMorph {
    public IBlockState block = Blocks.field_150348_b.func_176223_P();
    public BlockPos blockPos;

    public BlockMorph() {
        this.name = "metamorph.Block";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderOnScreen(EntityPlayer player, int x, int y, float scale, float alpha) {
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.func_179126_j();
        BlockRendererDispatcher blockrendererdispatcher = mc.func_175602_ab();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)(-scale), (float)(-scale));
        GlStateManager.func_179114_b((float)45.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
        mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        blockrendererdispatcher.func_175016_a(this.block, 1.0f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179097_i();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(EntityLivingBase entity, double x, double y, double z, float entityYaw, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.func_179091_B();
        BlockRendererDispatcher blockrendererdispatcher = mc.func_175602_ab();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y + 0.5f), (float)((float)z));
        mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)0.5f);
        blockrendererdispatcher.func_175016_a(this.block, 1.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179101_C();
    }

    @Override
    public void update(EntityLivingBase target, IMorphing cap) {
        super.update(target, cap);
        if (this.blockPos != null) {
            target.field_70179_y = 0.0;
            target.field_70181_x = 0.0;
            target.field_70159_w = 0.0;
            target.func_70107_b((double)this.blockPos.func_177958_n() + 0.5, (double)this.blockPos.func_177956_o(), (double)this.blockPos.func_177952_p() + 0.5);
        }
        this.updateSize(target, this.getWidth(target), this.getHeight(target));
    }

    @Override
    public AbstractMorph clone(boolean isRemote) {
        BlockMorph morph = new BlockMorph();
        morph.name = this.name;
        morph.settings = this.settings;
        if (isRemote) {
            morph.renderer = this.renderer;
        }
        morph.block = this.block;
        morph.blockPos = this.blockPos;
        return morph;
    }

    @Override
    public boolean equals(Object obj) {
        boolean result = super.equals(obj);
        if (obj instanceof BlockMorph) {
            BlockMorph morph = (BlockMorph)obj;
            result = result && Objects.equal((Object)morph.block, (Object)this.block);
            result = result && Objects.equal((Object)morph.blockPos, (Object)this.blockPos);
        }
        return result;
    }

    @Override
    public void fromNBT(NBTTagCompound tag) {
        int[] pos;
        Block block;
        super.fromNBT(tag);
        if (tag.func_74764_b("Block") && (block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(tag.func_74779_i("Block")))) != null) {
            IBlockState iBlockState = this.block = tag.func_74764_b("Meta") ? block.func_176203_a((int)tag.func_74771_c("Meta")) : block.func_176223_P();
        }
        if (tag.func_74764_b("Pos") && (pos = tag.func_74759_k("Pos")).length == 3) {
            this.blockPos = new BlockPos(pos[0], pos[1], pos[2]);
        }
    }

    @Override
    public void toNBT(NBTTagCompound tag) {
        super.toNBT(tag);
        if (this.block != null) {
            tag.func_74778_a("Block", ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)this.block.func_177230_c()).toString());
            tag.func_74774_a("Meta", (byte)this.block.func_177230_c().func_176201_c(this.block));
        }
        if (this.blockPos != null) {
            tag.func_74783_a("Pos", new int[]{this.blockPos.func_177958_n(), this.blockPos.func_177956_o(), this.blockPos.func_177952_p()});
        }
    }

    @Override
    public float getWidth(EntityLivingBase target) {
        return 0.99f;
    }

    @Override
    public float getHeight(EntityLivingBase target) {
        return 0.99f;
    }
}

