/*
 * Decompiled with CFR 0.152.
 */
package mchorse.vanilla_pack.morphs;

import com.mojang.authlib.GameProfile;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.api.morphs.EntityMorph;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PlayerMorph
extends EntityMorph {
    public GameProfile profile;

    public PlayerMorph() {
        this.name = "Player";
    }

    public void setProfile(String username) {
        this.profile = new GameProfile(null, username);
        this.profile = TileEntitySkull.func_174884_b((GameProfile)this.profile);
    }

    @Override
    public void setupEntity(World world) {
        EntityPlayer created = null;
        created = world.field_72995_K ? this.getPlayerClient(world) : new EntityPlayer(world, this.profile){

            public boolean func_175149_v() {
                return true;
            }

            public boolean func_184812_l_() {
                return false;
            }
        };
        created.deserializeNBT(this.entityData);
        created.field_70725_aQ = 0;
        created.field_70737_aN = 0;
        created.field_184619_aG = 0.0f;
        created.func_70015_d(0);
        this.setEntity((EntityLivingBase)created);
        if (world.field_72995_K) {
            this.setupRenderer();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private EntityPlayer getPlayerClient(World world) {
        return new PlayerMorphClientEntity(world, this.profile);
    }

    @Override
    protected void updateEntity(EntityLivingBase target) {
        EntityPlayer entity = (EntityPlayer)this.entity;
        entity.func_184819_a(target.func_184591_cq());
        entity.field_71091_bM = entity.field_71094_bP;
        entity.field_71096_bN = entity.field_71095_bQ;
        entity.field_71097_bO = entity.field_71085_bR;
        double d0 = entity.field_70165_t - entity.field_71094_bP;
        double d1 = entity.field_70163_u - entity.field_71095_bQ;
        double d2 = entity.field_70161_v - entity.field_71085_bR;
        if (d0 > 10.0) {
            entity.field_71091_bM = entity.field_71094_bP = entity.field_70165_t;
        }
        if (d2 > 10.0) {
            entity.field_71097_bO = entity.field_71085_bR = entity.field_70161_v;
        }
        if (d1 > 10.0) {
            entity.field_71096_bN = entity.field_71095_bQ = entity.field_70163_u;
        }
        if (d0 < -10.0) {
            entity.field_71091_bM = entity.field_71094_bP = entity.field_70165_t;
        }
        if (d2 < -10.0) {
            entity.field_71097_bO = entity.field_71085_bR = entity.field_70161_v;
        }
        if (d1 < -10.0) {
            entity.field_71096_bN = entity.field_71095_bQ = entity.field_70163_u;
        }
        entity.field_71094_bP += d0 * 0.25;
        entity.field_71085_bR += d2 * 0.25;
        entity.field_71095_bQ += d1 * 0.25;
    }

    @Override
    public AbstractMorph clone(boolean isRemote) {
        PlayerMorph morph = new PlayerMorph();
        morph.name = this.name;
        morph.settings = this.settings;
        morph.entityData = this.entityData.func_74737_b();
        morph.profile = this.profile;
        if (isRemote) {
            morph.renderer = this.renderer;
        }
        return morph;
    }

    @Override
    public void reset() {
        super.reset();
        this.profile = null;
    }

    @Override
    public boolean equals(Object obj) {
        boolean result = super.equals(obj);
        if (obj instanceof PlayerMorph) {
            PlayerMorph morph = (PlayerMorph)obj;
            result = result && morph.profile.equals((Object)this.profile);
        }
        return result;
    }

    @Override
    public void fromNBT(NBTTagCompound tag) {
        super.fromNBT(tag);
        if (tag.func_150297_b("PlayerProfile", 10)) {
            this.profile = NBTUtil.func_152459_a((NBTTagCompound)tag.func_74775_l("PlayerProfile"));
        } else if (tag.func_74764_b("Username")) {
            this.setProfile(tag.func_74779_i("Username"));
        }
    }

    @Override
    public void toNBT(NBTTagCompound tag) {
        super.toNBT(tag);
        if (this.profile != null) {
            NBTTagCompound profileTag = new NBTTagCompound();
            NBTUtil.func_180708_a((NBTTagCompound)profileTag, (GameProfile)this.profile);
            tag.func_74782_a("PlayerProfile", (NBTBase)profileTag);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class PlayerMorphClientEntity
    extends EntityOtherPlayerMP {
        public GameProfile profile;
        public boolean isBaby;
        public String skinType = "";
        public NetworkPlayerInfo info;

        public PlayerMorphClientEntity(World world, GameProfile profile) {
            super(world, profile);
            this.profile = profile;
        }

        protected void initiateNetworkInfo() {
            if (this.info == null) {
                this.info = new NetworkPlayerInfo(this.profile);
            }
        }

        public boolean func_70631_g_() {
            return this.isBaby;
        }

        public String func_175154_l() {
            if (this.skinType.isEmpty()) {
                this.initiateNetworkInfo();
                return this.info.func_178851_f();
            }
            return this.skinType.equals("alex") ? "slim" : "default";
        }

        public ResourceLocation func_110306_p() {
            this.initiateNetworkInfo();
            return this.info.func_178837_g();
        }

        public ResourceLocation func_110303_q() {
            this.initiateNetworkInfo();
            return this.info.func_178861_h();
        }

        @SideOnly(value=Side.CLIENT)
        public boolean func_175148_a(EnumPlayerModelParts part) {
            return true;
        }

        public boolean func_152122_n() {
            return this.info != null;
        }

        public void func_70037_a(NBTTagCompound compound) {
            super.func_70037_a(compound);
            this.isBaby = compound.func_74767_n("IsBaby");
            this.skinType = compound.func_74779_i("SkinType");
        }

        public void func_70014_b(NBTTagCompound compound) {
            super.func_70014_b(compound);
            compound.func_74757_a("IsBaby", this.isBaby);
            compound.func_74778_a("SkinType", this.skinType);
        }
    }
}

