/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.framework.elements;

import mchorse.mclib.client.gui.framework.GuiTooltip;
import mchorse.mclib.client.gui.framework.elements.GuiElements;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.utils.Area;
import mchorse.mclib.client.gui.utils.Resizer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiElement
extends Gui
implements IGuiElement {
    public Area area = new Area();
    public Resizer resizer;
    public GuiElements<IGuiElement> children;
    protected boolean enabled = true;
    protected boolean visible = true;
    protected Minecraft mc;
    protected FontRenderer font;

    public GuiElement(Minecraft mc) {
        this.mc = mc;
        this.font = mc.field_71466_p;
    }

    public GuiElement createChildren() {
        if (this.children == null) {
            this.children = new GuiElements();
        }
        return this;
    }

    public Resizer resizer() {
        if (this.resizer == null) {
            this.resizer = new Resizer();
        }
        return this.resizer;
    }

    public GuiElement setResizer(Resizer resizer) {
        this.resizer = resizer;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled && this.visible;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void toggleVisible() {
        this.visible = !this.visible;
    }

    @Override
    public void resize(int width, int height) {
        if (this.resizer != null) {
            this.resizer.apply(this.area);
        }
        if (this.children != null) {
            this.children.resize(width, height);
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (this.children != null) {
            return this.children.mouseClicked(mouseX, mouseY, mouseButton);
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(int mouseX, int mouseY, int scroll) {
        if (this.children != null) {
            return this.children.mouseScrolled(mouseX, mouseY, scroll);
        }
        return false;
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY, int state) {
        if (this.children != null) {
            this.children.mouseReleased(mouseX, mouseY, state);
        }
    }

    @Override
    public boolean hasActiveTextfields() {
        if (this.children != null) {
            return this.children.hasActiveTextfields();
        }
        return false;
    }

    @Override
    public void unfocus() {
        if (this.children != null) {
            this.children.unfocus();
        }
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) {
        if (this.children != null) {
            this.children.keyTyped(typedChar, keyCode);
        }
    }

    @Override
    public void draw(GuiTooltip tooltip, int mouseX, int mouseY, float partialTicks) {
        if (this.children != null) {
            this.children.draw(tooltip, mouseX, mouseY, partialTicks);
        }
    }
}

