/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.framework.elements;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mchorse.mclib.client.gui.framework.GuiTooltip;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiLegacy;

public class GuiElements<T extends IGuiElement>
implements IGuiElement,
IGuiLegacy {
    public List<T> elements = new ArrayList<T>();
    protected boolean enabled = true;
    protected boolean visible = true;

    public void add(T element) {
        if (element != null) {
            this.elements.add(element);
        }
    }

    public void add(T ... elements) {
        for (T element : elements) {
            if (element == null) continue;
            this.elements.add(element);
        }
    }

    @Override
    public void resize(int width, int height) {
        for (IGuiElement element : this.elements) {
            element.resize(width, height);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled && this.visible;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public boolean handleMouseInput(int mouseX, int mouseY) throws IOException {
        for (IGuiElement element : this.elements) {
            if (!(element instanceof IGuiLegacy) || !((IGuiLegacy)((Object)element)).handleMouseInput(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            IGuiElement element = (IGuiElement)this.elements.get(i);
            if (!element.isEnabled() || !element.mouseClicked(mouseX, mouseY, mouseButton)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(int mouseX, int mouseY, int scroll) {
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            IGuiElement element = (IGuiElement)this.elements.get(i);
            if (!element.isEnabled() || !element.mouseScrolled(mouseX, mouseY, scroll)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY, int state) {
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            IGuiElement element = (IGuiElement)this.elements.get(i);
            if (!element.isEnabled()) continue;
            element.mouseReleased(mouseX, mouseY, state);
        }
    }

    @Override
    public boolean hasActiveTextfields() {
        if (this.isEnabled()) {
            for (IGuiElement element : this.elements) {
                if (!element.isEnabled() || !element.hasActiveTextfields()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void unfocus() {
        for (IGuiElement element : this.elements) {
            element.unfocus();
        }
    }

    @Override
    public boolean handleKeyboardInput() throws IOException {
        for (IGuiElement element : this.elements) {
            if (!(element instanceof IGuiLegacy) || !((IGuiLegacy)((Object)element)).handleKeyboardInput()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) {
        for (IGuiElement element : this.elements) {
            if (!element.isEnabled()) continue;
            element.keyTyped(typedChar, keyCode);
        }
    }

    @Override
    public void draw(GuiTooltip tooltip, int mouseX, int mouseY, float partialTicks) {
        for (IGuiElement element : this.elements) {
            if (!element.isVisible()) continue;
            element.draw(tooltip, mouseX, mouseY, partialTicks);
        }
    }
}

