/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.framework.elements;

import java.util.function.Consumer;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.GuiTooltip;
import mchorse.mclib.client.gui.framework.elements.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.GuiTextElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiFolderEntryList;
import mchorse.mclib.client.gui.framework.elements.list.GuiResourceLocationList;
import mchorse.mclib.client.gui.widgets.buttons.GuiTextureButton;
import mchorse.mclib.utils.files.FileTree;
import mchorse.mclib.utils.files.GlobalTree;
import mchorse.mclib.utils.files.entries.AbstractEntry;
import mchorse.mclib.utils.files.entries.FileEntry;
import mchorse.mclib.utils.files.entries.FolderEntry;
import mchorse.mclib.utils.resources.MultiResourceLocation;
import mchorse.mclib.utils.resources.RLUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.lwjgl.opengl.GL11;

public class GuiTexturePicker
extends GuiElement {
    public GuiTextElement text;
    public GuiButtonElement<GuiButton> close;
    public GuiButtonElement<GuiButton> folder;
    public GuiFolderEntryList picker;
    public GuiButtonElement<GuiButton> multi;
    public GuiButtonElement<GuiTextureButton> add;
    public GuiButtonElement<GuiTextureButton> remove;
    public GuiResourceLocationList multiList;
    public Consumer<ResourceLocation> callback;
    public MultiResourceLocation multiRL;
    public ResourceLocation current;
    public FileTree tree = GlobalTree.TREE;
    private long lastChecked;
    private long lastTyped;
    private String typed = "";

    public GuiTexturePicker(Minecraft mc, Consumer<ResourceLocation> callback) {
        super(mc);
        this.text = new GuiTextElement(mc, 1000, str -> this.selectCurrent(str.isEmpty() ? null : RLUtils.create(str)));
        this.close = GuiButtonElement.button(mc, "X", b -> this.setVisible(false));
        this.folder = GuiButtonElement.button(mc, I18n.func_135052_a((String)"mclib.gui.open_folder", (Object[])new Object[0]), b -> this.openFolder());
        this.picker = new GuiFolderEntryList(mc, entry -> {
            ResourceLocation rl = entry.resource;
            this.selectCurrent(rl);
            this.text.setText(rl == null ? "" : rl.toString());
        }){

            @Override
            public void setFolder(FolderEntry folder) {
                super.setFolder(folder);
                GuiTexturePicker.this.updateFolderButton();
            }
        };
        this.multi = GuiButtonElement.button(mc, I18n.func_135052_a((String)"mclib.gui.multi_skin", (Object[])new Object[0]), b -> this.toggleMultiSkin());
        this.multiList = new GuiResourceLocationList(mc, rl -> this.displayCurrent((ResourceLocation)rl));
        this.add = GuiButtonElement.icon(mc, GuiBase.ICONS, 32, 32, 32, 48, b -> this.addMultiSkin());
        this.remove = GuiButtonElement.icon(mc, GuiBase.ICONS, 64, 32, 64, 48, b -> this.removeMultiSkin());
        this.createChildren();
        this.text.resizer().set(115.0f, 5.0f, 0.0f, 20.0f).parent(this.area).w(1.0f, -145);
        this.close.resizer().set(0.0f, 5.0f, 20.0f, 20.0f).parent(this.area).x(1.0f, -25);
        this.folder.resizer().set(0.0f, 0.0f, 80.0f, 20.0f).parent(this.area).x(1.0f, -90).y(1.0f, -30);
        this.picker.resizer().set(115.0f, 30.0f, 0.0f, 0.0f).parent(this.area).w(1.0f, -120).h(1.0f, -30);
        this.multi.resizer().parent(this.area).set(5.0f, 5.0f, 100.0f, 20.0f);
        this.add.resizer().parent(this.area).set(67.0f, 7.0f, 16.0f, 16.0f);
        this.remove.resizer().relative(this.add.resizer()).set(20.0f, 0.0f, 16.0f, 16.0f);
        this.multiList.resizer().set(5.0f, 35.0f, 100.0f, 0.0f).parent(this.area).h(1.0f, -40);
        this.children.add(new IGuiElement[]{this.picker, this.multi, this.multiList, this.text, this.close, this.folder, this.add, this.remove});
        this.callback = callback;
    }

    public void refresh() {
        this.picker.update();
        this.updateFolderButton();
    }

    public void openFolder() {
        if (this.picker.parent != null && this.picker.parent.file != null) {
            mchorse.mclib.client.gui.utils.GuiUtils.openWebLink(this.picker.parent.file.toURI());
        }
    }

    public void updateFolderButton() {
        this.folder.setEnabled(this.picker.parent != null && this.picker.parent.file != null);
    }

    public void fill(ResourceLocation skin) {
        this.setMultiSkin(skin, false);
    }

    private void addMultiSkin() {
        ResourceLocation rl = this.current;
        if (rl == null && !this.text.field.func_146179_b().isEmpty()) {
            rl = RLUtils.create(this.text.field.func_146179_b());
        }
        this.multiList.add(rl);
        this.multiList.current = this.multiList.getList().size() - 1;
        this.displayCurrent((ResourceLocation)this.multiList.getCurrent());
    }

    private void removeMultiSkin() {
        if (this.multiList.current >= 0 && this.multiList.getList().size() > 1) {
            this.multiList.getList().remove(this.multiList.current);
            this.multiList.update();
            --this.multiList.current;
            if (this.multiList.current >= 0) {
                this.displayCurrent((ResourceLocation)this.multiList.getCurrent());
            }
        }
    }

    protected void displayCurrent(ResourceLocation rl) {
        FolderEntry folder;
        this.current = rl;
        this.picker.rl = rl;
        this.text.setText(rl == null ? "" : rl.toString());
        this.text.field.func_146196_d();
        if (this.tree != null && ((folder = this.tree.getByPath(rl == null ? "" : rl.func_110624_b() + "/" + rl.func_110623_a())) != this.tree.root || this.picker.getList().isEmpty())) {
            this.picker.setList(folder.getEntries());
            this.picker.parent = folder;
            this.picker.setCurrent(rl);
            this.picker.update();
            this.updateFolderButton();
        }
    }

    protected void selectCurrent(ResourceLocation rl) {
        try {
            this.mc.field_71446_o.func_110577_a(rl);
        }
        catch (Exception e) {
            return;
        }
        this.current = rl;
        this.picker.rl = rl;
        if (this.multiRL != null) {
            if (this.multiList.current != -1 && rl != null) {
                this.multiList.getList().set(this.multiList.current, rl);
            }
            rl = this.multiRL;
        }
        if (this.callback != null) {
            this.callback.accept(rl);
        }
    }

    protected void toggleMultiSkin() {
        if (this.multiRL != null) {
            this.setMultiSkin(this.multiRL.children.get(0), true);
        } else if (this.current != null) {
            this.setMultiSkin(new MultiResourceLocation(this.current.toString()), true);
        } else {
            ResourceLocation rl = this.picker.getCurrentResource();
            if (rl != null) {
                this.setMultiSkin(rl, true);
            }
        }
    }

    protected void setMultiSkin(ResourceLocation skin, boolean notify) {
        boolean show = skin instanceof MultiResourceLocation;
        if (show) {
            this.multiRL = (MultiResourceLocation)skin;
            this.displayCurrent(this.multiRL.children.get(0));
            this.multiList.current = this.multiRL.children.isEmpty() ? -1 : 0;
            this.multiList.setList(this.multiRL.children);
            this.picker.resizer().set(115.0f, 30.0f, 0.0f, 0.0f).parent(this.area).w(1.0f, -120).h(1.0f, -30);
            this.multi.resizer().set(5.0f, 5.0f, 60.0f, 20.0f).parent(this.area);
        } else {
            this.multiRL = null;
            this.picker.resizer().set(5.0f, 30.0f, 0.0f, 0.0f).parent(this.area).w(1.0f, -10).h(1.0f, -30);
            this.multi.resizer().set(5.0f, 5.0f, 100.0f, 20.0f).parent(this.area);
            this.displayCurrent(skin);
        }
        if (notify && show) {
            if (this.callback != null) {
                this.callback.accept(skin);
            } else {
                this.selectCurrent(skin);
            }
        }
        this.multiList.setVisible(show);
        this.add.setVisible(show);
        this.remove.setVisible(show);
        GuiScreen screen = this.mc.field_71462_r;
        this.picker.resize(screen.field_146294_l, screen.field_146295_m);
        this.multi.resize(screen.field_146294_l, screen.field_146295_m);
        this.updateFolderButton();
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        return super.mouseClicked(mouseX, mouseY, mouseButton) || this.isVisible() && this.area.isInside(mouseX, mouseY);
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) {
        if (this.hasActiveTextfields()) {
            super.keyTyped(typedChar, keyCode);
        } else if (keyCode == 28) {
            AbstractEntry entry = (AbstractEntry)this.picker.getCurrent();
            if (entry instanceof FolderEntry) {
                this.picker.setFolder((FolderEntry)entry);
            } else if (entry instanceof FileEntry) {
                this.selectCurrent(((FileEntry)entry).resource);
            }
            this.typed = "";
        } else if (keyCode == 200) {
            this.moveCurrent(-1, GuiScreen.func_146272_n());
        } else if (keyCode == 208) {
            this.moveCurrent(1, GuiScreen.func_146272_n());
        } else if (!this.pickByTyping(typedChar)) {
            super.keyTyped(typedChar, keyCode);
        }
    }

    protected void moveCurrent(int factor, boolean top) {
        int index = this.picker.current + factor;
        int length = this.picker.getList().size();
        if (index < 0) {
            index = length - 1;
        } else if (index >= length) {
            index = 0;
        }
        if (top) {
            index = factor > 0 ? length - 1 : 0;
        }
        this.picker.current = index;
        this.picker.scroll.scrollIntoView(index * this.picker.scroll.scrollItemSize);
        this.typed = "";
    }

    protected boolean pickByTyping(char typedChar) {
        if (!ChatAllowedCharacters.func_71566_a((char)typedChar)) {
            return false;
        }
        long diff = System.currentTimeMillis() - this.lastTyped;
        if (diff > 1000L) {
            this.typed = "";
        }
        this.typed = this.typed + Character.toString(typedChar);
        this.lastTyped = System.currentTimeMillis();
        for (AbstractEntry entry : this.picker.getList()) {
            if (!entry.title.startsWith(this.typed)) continue;
            this.picker.setCurrentScroll(entry);
            return true;
        }
        return false;
    }

    @Override
    public void draw(GuiTooltip tooltip, int mouseX, int mouseY, float partialTicks) {
        ResourceLocation loc;
        long time = System.currentTimeMillis();
        if (this.lastChecked + 1000L < time) {
            this.lastChecked = time;
            FolderEntry folder = this.picker.parent;
            if (folder != null && folder.isTop()) {
                folder = folder.top;
            }
            if (folder != null && folder.hasChanged()) {
                this.picker.setDirectFolder(folder);
            }
        }
        this.func_73733_a(this.area.x, this.area.y, this.area.getX(1.0f), this.area.getY(1.0f), -2013265920, -16777216);
        if (this.multiList.isVisible()) {
            this.mc.field_71446_o.func_110577_a(GuiBase.ICONS);
            GuiUtils.drawContinuousTexturedBox((int)this.area.x, (int)this.area.y, (int)0, (int)32, (int)110, (int)this.area.h, (int)32, (int)32, (int)0, (float)0.0f);
            GuiTexturePicker.func_73734_a((int)this.area.x, (int)this.area.y, (int)(this.area.x + 110), (int)(this.area.y + 30), (int)0x44000000);
            this.func_73733_a(this.area.x, this.area.getY(1.0f) - 20, this.area.x + 110, this.area.getY(1.0f), 0, 0x44000000);
        }
        if (this.picker.getList().isEmpty()) {
            this.func_73732_a(this.font, I18n.func_135052_a((String)"mclib.gui.no_data", (Object[])new Object[0]), this.area.getX(0.5f), this.area.getY(0.5f), 0xFFFFFF);
        }
        super.draw(tooltip, mouseX, mouseY, partialTicks);
        if (System.currentTimeMillis() - this.lastTyped < 1000L) {
            int w = this.font.func_78256_a(this.typed);
            int x = this.text.area.x;
            int y = this.text.area.getY(1.0f);
            Gui.func_73734_a((int)x, (int)y, (int)(x + w + 4), (int)(y + 4 + this.font.field_78288_b), (int)-2013230849);
            this.font.func_175063_a(this.typed, (float)(x + 2), (float)(y + 2), 0xFFFFFF);
        }
        if ((loc = this.current) != null) {
            this.mc.field_71446_o.func_110577_a(loc);
            int w = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
            int h = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
            int x = this.area.getX(1.0f);
            int y = this.area.getY(1.0f);
            int fw = w;
            int fh = h;
            if (fw > 128 || fh > 128) {
                fh = 128;
                fw = 128;
                if (w > h) {
                    fh = (int)((float)h / (float)w * (float)fw);
                } else if (h > w) {
                    fw = (int)((float)w / (float)h * (float)fh);
                }
            }
            this.mc.field_71446_o.func_110577_a(GuiBase.ICONS);
            GuiUtils.drawContinuousTexturedBox((int)(x -= fw + 10), (int)(y -= fh + 40), (int)0, (int)96, (int)fw, (int)fh, (int)32, (int)32, (int)0, (float)0.0f);
            this.mc.field_71446_o.func_110577_a(loc);
            GlStateManager.func_179141_d();
            Tessellator tessellator = Tessellator.func_178181_a();
            VertexBuffer vertexbuffer = tessellator.func_178180_c();
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vertexbuffer.func_181662_b((double)x, (double)(y + fh), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
            vertexbuffer.func_181662_b((double)(x + fw), (double)(y + fh), 0.0).func_187315_a(1.0, 1.0).func_181675_d();
            vertexbuffer.func_181662_b((double)(x + fw), (double)y, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
            vertexbuffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
        }
    }
}

