/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.framework.elements.list;

import java.util.List;
import java.util.function.Consumer;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.list.GuiListElement;
import mchorse.mclib.utils.files.entries.AbstractEntry;
import mchorse.mclib.utils.files.entries.FileEntry;
import mchorse.mclib.utils.files.entries.FolderEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class GuiFolderEntryList
extends GuiListElement<AbstractEntry> {
    public Consumer<FileEntry> fileCallback;
    public ResourceLocation rl;
    public FolderEntry parent;

    public GuiFolderEntryList(Minecraft mc, Consumer<FileEntry> fileCallback) {
        super(mc, null);
        this.callback = entry -> {
            if (entry instanceof FileEntry) {
                if (this.fileCallback != null) {
                    this.fileCallback.accept((FileEntry)entry);
                }
            } else if (entry.isFolder()) {
                this.setFolder((FolderEntry)entry);
            }
        };
        this.fileCallback = fileCallback;
        this.scroll.scrollItemSize = 16;
        this.scroll.scrollSpeed = 16;
    }

    public void setFolder(FolderEntry folder) {
        if (folder.getEntries().size() <= 2 && !folder.isTop()) {
            for (AbstractEntry subEntry : folder.getEntries()) {
                FolderEntry subFolder;
                if (!subEntry.isFolder() || (subFolder = (FolderEntry)subEntry).isTop()) continue;
                this.setFolder(subFolder);
                return;
            }
        }
        this.setDirectFolder(folder);
    }

    public void setDirectFolder(FolderEntry folder) {
        List<AbstractEntry> entries = folder.getEntries();
        AbstractEntry current = (AbstractEntry)this.getCurrent();
        this.parent = folder;
        this.setList(entries);
        int n = this.current = current == null ? -1 : entries.indexOf(current);
        if (this.current == -1) {
            this.setCurrent(this.rl);
        }
    }

    public ResourceLocation getCurrentResource() {
        AbstractEntry entry = (AbstractEntry)this.getCurrent();
        if (entry != null && entry instanceof FileEntry) {
            return ((FileEntry)entry).resource;
        }
        return null;
    }

    @Override
    public void setCurrent(ResourceLocation rl) {
        this.current = -1;
        if (rl == null) {
            return;
        }
        int c = this.list.size();
        for (int i = 0; i < c; ++i) {
            AbstractEntry entry = (AbstractEntry)this.list.get(i);
            if (!(entry instanceof FileEntry) || !((FileEntry)entry).resource.equals((Object)rl)) continue;
            this.current = i;
            break;
        }
    }

    @Override
    public void sort() {
    }

    @Override
    public void drawElement(AbstractEntry element, int i, int x, int y, boolean hover) {
        if (this.current == i) {
            Gui.func_73734_a((int)x, (int)y, (int)(x + this.scroll.w), (int)(y + this.scroll.scrollItemSize), (int)-2013230849);
        }
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        this.mc.field_71446_o.func_110577_a(GuiBase.ICONS);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(hover ? 0.8f : 0.6f));
        if (element instanceof FolderEntry) {
            Gui.func_152125_a((int)(x + 2), (int)y, (float)112.0f, (float)64.0f, (int)16, (int)16, (int)16, (int)16, (float)256.0f, (float)256.0f);
        } else {
            Gui.func_152125_a((int)(x + 2), (int)y, (float)96.0f, (float)64.0f, (int)16, (int)16, (int)16, (int)16, (float)256.0f, (float)256.0f);
        }
        this.font.func_175063_a(element.title, (float)(x + 20), (float)(y + 4), hover ? 0xFFFFA0 : 0xFFFFFF);
    }
}

