/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.utils;

import mchorse.mclib.client.gui.utils.Area;

public class Resizer {
    public Unit x = new Unit();
    public Unit y = new Unit();
    public Unit w = new Unit();
    public Unit h = new Unit();
    public int maxW;
    public int maxH;
    public float anchorX;
    public float anchorY;
    public Resizer relative;
    public Area parent;

    public Resizer set(float x, float y, float w, float h) {
        return this.set(x, y, w, h, Measure.PIXELS);
    }

    public Resizer set(float x, float y, float w, float h, Measure measure) {
        this.x.set(x, measure);
        this.y.set(y, measure);
        this.w.set(w, measure);
        this.h.set(h, measure);
        return this;
    }

    public Resizer x(int value) {
        this.x.set(value, Measure.PIXELS, 0);
        return this;
    }

    public Resizer x(float value, int padding) {
        this.x.set(value, Measure.RELATIVE, padding);
        return this;
    }

    public Resizer y(int value) {
        this.y.set(value, Measure.PIXELS, 0);
        return this;
    }

    public Resizer y(float value, int padding) {
        this.y.set(value, Measure.RELATIVE, padding);
        return this;
    }

    public Resizer w(int value) {
        this.w.set(value, Measure.PIXELS, 0);
        return this;
    }

    public Resizer w(float value, int padding) {
        this.w.set(value, Measure.RELATIVE, padding);
        return this;
    }

    public Resizer h(int value) {
        this.h.set(value, Measure.PIXELS, 0);
        return this;
    }

    public Resizer h(float value, int padding) {
        this.h.set(value, Measure.RELATIVE, padding);
        return this;
    }

    public Resizer maxW(int max) {
        this.maxW = max;
        return this;
    }

    public Resizer maxH(int max) {
        this.maxH = max;
        return this;
    }

    public Resizer relative(Resizer relative) {
        this.relative = relative;
        this.parent = null;
        return this;
    }

    public Resizer parent(Area parent) {
        this.parent = parent;
        this.relative = null;
        return this;
    }

    public void apply(Area area) {
        if (this.w.enabled) {
            area.w = this.getW();
        }
        if (this.h.enabled) {
            area.h = this.getH();
        }
        if (this.x.enabled) {
            area.x = this.getX();
        }
        if (this.y.enabled) {
            area.y = this.getY();
        }
    }

    public int getX() {
        int value = (int)this.x.value;
        if (this.relative != null) {
            value += this.relative.getX();
            if (this.x.unit == Measure.RELATIVE) {
                value = this.relative.getX() + (int)((float)this.relative.getW() * this.x.value);
            }
        } else if (this.parent != null) {
            value += this.parent.x;
            if (this.x.unit == Measure.RELATIVE) {
                value = this.parent.x + (int)((float)this.parent.w * this.x.value);
            }
        }
        return value + this.x.padding;
    }

    public int getY() {
        int value = (int)this.y.value;
        if (this.relative != null) {
            value += this.relative.getY();
            if (this.y.unit == Measure.RELATIVE) {
                value = this.relative.getY() + (int)((float)this.relative.getH() * this.y.value);
            }
        } else if (this.parent != null) {
            value += this.parent.y;
            if (this.y.unit == Measure.RELATIVE) {
                value = this.parent.y + (int)((float)this.parent.h * this.y.value);
            }
        }
        return value + this.y.padding;
    }

    public int getW() {
        int value = (int)this.w.value;
        if (this.relative != null && this.w.unit == Measure.RELATIVE) {
            value = (int)((float)this.relative.getW() * this.w.value);
        } else if (this.parent != null && this.w.unit == Measure.RELATIVE) {
            value = (int)((float)this.parent.w * this.w.value);
        }
        value += this.w.padding;
        if (this.maxW > 0) {
            value = Math.min(value, this.maxW);
        }
        return value;
    }

    public int getH() {
        int value = (int)this.h.value;
        if (this.relative != null && this.h.unit == Measure.RELATIVE) {
            value = (int)((float)this.relative.getH() * this.h.value);
        } else if (this.parent != null && this.h.unit == Measure.RELATIVE) {
            value = (int)((float)this.parent.h * this.h.value);
        }
        value += this.h.padding;
        if (this.maxH > 0) {
            value = Math.min(value, this.maxH);
        }
        return value;
    }

    public static enum Measure {
        PIXELS,
        RELATIVE;

    }

    public static class Unit {
        public float value;
        public int padding;
        public boolean enabled = true;
        public Measure unit = Measure.PIXELS;

        public void set(float value, Measure unit) {
            this.set(value, unit, 0);
        }

        public void set(float value, Measure unit, int padding) {
            this.value = value;
            this.unit = unit;
            this.padding = padding;
        }

        public void disable() {
            this.enabled = false;
        }
    }
}

