/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.widgets;

import mchorse.mclib.client.gui.utils.Area;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.lwjgl.input.Keyboard;

public class GuiTrackpad {
    public static final ResourceLocation VANILLA_BUTTONS = new ResourceLocation("textures/gui/widgets.png");
    private FontRenderer font;
    public GuiTextField text;
    public Area area = new Area();
    public String title = "";
    public float value;
    public float amplitude = 0.25f;
    public float min = Float.NEGATIVE_INFINITY;
    public float max = Float.POSITIVE_INFINITY;
    public boolean integer;
    private boolean dragging;
    private int lastX;
    private int lastY;
    private float lastValue;
    private ITrackpadListener listener;

    public GuiTrackpad(ITrackpadListener listener, FontRenderer font) {
        this.listener = listener;
        this.text = new GuiTextField(0, font, 0, 0, 0, 0);
        this.text.func_146185_a(false);
        this.font = font;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void setValue(float value) {
        value = (float)Math.round(value * 1000.0f) / 1000.0f;
        value = MathHelper.func_76131_a((float)value, (float)this.min, (float)this.max);
        if (this.integer) {
            value = (int)value;
        }
        this.value = value;
        this.text.func_146180_a(this.integer ? String.valueOf((int)value) : String.valueOf(value));
        this.text.func_146196_d();
    }

    public void setValueAndNotify(float value) {
        this.setValue(value);
        if (this.listener != null) {
            this.listener.setTrackpadValue(this, value);
        }
    }

    public GuiTrackpad update(int x, int y, int w, int h) {
        this.area.set(x, y, w, h);
        this.text.field_146209_f = x + 4;
        this.text.field_146210_g = y + h / 2 - 4;
        this.text.field_146218_h = (int)((float)w / 1.5f) - 2;
        this.text.field_146219_i = 9;
        this.text.func_146196_d();
        return this;
    }

    public GuiTrackpad setTitle(String title) {
        this.title = title;
        return this;
    }

    public void keyTyped(char typedChar, int keyCode) {
        String old = this.text.func_146179_b();
        this.text.func_146201_a(typedChar, keyCode);
        String text = this.text.func_146179_b();
        if (this.text.func_146206_l() && !text.equals(old)) {
            try {
                float f = this.value = text.isEmpty() ? 0.0f : Float.parseFloat(text);
                if (this.listener != null) {
                    this.listener.setTrackpadValue(this, this.value);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        this.text.func_146192_a(mouseX, mouseY, mouseButton);
        if (!this.text.func_146206_l() && this.area.isInside(mouseX, mouseY)) {
            if (Keyboard.isKeyDown((int)29)) {
                this.setValueAndNotify(Math.round(this.value));
            }
            this.dragging = true;
            this.lastX = mouseX;
            this.lastY = mouseY;
            this.lastValue = this.value;
        }
    }

    public void mouseReleased(int mouseX, int mouseY, int state) {
        this.dragging = false;
    }

    public void draw(int mouseX, int mouseY, float partialTicks) {
        int x = this.area.x;
        int y = this.area.y;
        int w = this.area.w;
        int h = this.area.h;
        GuiUtils.drawContinuousTexturedBox((ResourceLocation)VANILLA_BUTTONS, (int)x, (int)y, (int)0, (int)46, (int)w, (int)h, (int)200, (int)20, (int)0, (int)0, (int)1, (int)1, (float)0.0f);
        this.text.func_146194_f();
        if (!this.title.isEmpty()) {
            int lw = this.font.func_78256_a(this.title);
            this.font.func_78276_b(this.title, x + w - lw - 3, y + h / 2 - 4, -5592406);
        }
        if (this.dragging) {
            int dx = mouseX - this.lastX;
            int dy = mouseY - this.lastY;
            if (dx != 0 || dy != 0) {
                float amp = 1.0f;
                if (Keyboard.isKeyDown((int)42)) {
                    amp = 5.0f;
                } else if (Keyboard.isKeyDown((int)56)) {
                    amp = 0.2f;
                }
                float diff = (float)((int)Math.sqrt(dx * dx + dy * dy) - 3) * this.amplitude * amp;
                float newValue = this.lastValue + (dy < 0 ? diff : -diff);
                float f = newValue = diff < 0.0f ? this.lastValue : (float)Math.round(newValue * 1000.0f) / 1000.0f;
                if (this.value != newValue) {
                    this.setValueAndNotify(MathHelper.func_76131_a((float)newValue, (float)this.min, (float)this.max));
                }
            }
            Gui.func_73734_a((int)(this.lastX - 3), (int)(this.lastY - 3), (int)(this.lastX + 3), (int)(this.lastY + 3), (int)-1426063361);
        }
    }

    public static interface ITrackpadListener {
        public void setTrackpadValue(GuiTrackpad var1, float var2);
    }
}

