/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.math;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mchorse.mclib.math.Constant;
import mchorse.mclib.math.Group;
import mchorse.mclib.math.IValue;
import mchorse.mclib.math.Operation;
import mchorse.mclib.math.Operator;
import mchorse.mclib.math.Variable;
import mchorse.mclib.math.functions.Abs;
import mchorse.mclib.math.functions.Clamp;
import mchorse.mclib.math.functions.Cos;
import mchorse.mclib.math.functions.Floor;
import mchorse.mclib.math.functions.Function;
import mchorse.mclib.math.functions.Random;
import mchorse.mclib.math.functions.Sin;
import net.minecraft.util.math.MathHelper;

public class MathBuilder {
    public Map<String, IValue> variables = new HashMap<String, IValue>();
    public Map<String, Class<? extends Function>> functions = new HashMap<String, Class<? extends Function>>();

    public MathBuilder() {
        this.register(new Variable("PI", Math.PI));
        this.register(new Variable("E", Math.E));
        this.functions.put("abs", Abs.class);
        this.functions.put("clamp", Clamp.class);
        this.functions.put("cos", Cos.class);
        this.functions.put("floor", Floor.class);
        this.functions.put("sin", Sin.class);
        this.functions.put("random", Random.class);
    }

    public void register(Variable var) {
        this.variables.put(var.getName(), var);
    }

    public IValue parse(String expression) throws Exception {
        if (!expression.matches("^[\\w\\d\\s_+-/*%^.,()]+$")) {
            throw new Exception("Given expression '" + expression + "' contains illegal characters!");
        }
        if ((expression = expression.replaceAll("\\s+", "")).startsWith("(") && expression.endsWith(")")) {
            expression = expression.replaceAll("^\\(", "").replaceAll("\\)$", "");
        }
        String[] chars = expression.split("(?!^)");
        int left = 0;
        int right = 0;
        for (String s : chars) {
            if (s.equals("(")) {
                ++left;
                continue;
            }
            if (!s.equals(")")) continue;
            ++right;
        }
        if (left != right) {
            throw new Exception("Given expression '" + expression + "' has more uneven amount of parenthesis, there are " + left + " open and " + right + " closed!");
        }
        return this.parseSymbols(this.breakdownChars(chars));
    }

    public List<Object> breakdownChars(String[] chars) {
        ArrayList<Object> symbols = new ArrayList<Object>();
        String buffer = "";
        int len = chars.length;
        block0: for (int i = 0; i < len; ++i) {
            String s = chars[i];
            if (this.isOperator(s) || s.equals(",")) {
                if (s.equals("-")) {
                    boolean isOperatorBehind;
                    int size = symbols.size();
                    boolean isFirst = size == 0 && buffer.isEmpty();
                    boolean bl = isOperatorBehind = size > 0 && (this.isOperator(symbols.get(size - 1)) || symbols.get(size - 1).equals(",")) && buffer.isEmpty();
                    if (isFirst || isOperatorBehind) {
                        buffer = buffer + s;
                        continue;
                    }
                }
                if (!buffer.isEmpty()) {
                    symbols.add(buffer);
                    buffer = "";
                }
                symbols.add(s);
                continue;
            }
            if (s.equals("(")) {
                if (!buffer.isEmpty()) {
                    symbols.add(buffer);
                    buffer = "";
                }
                int counter = 1;
                for (int j = i + 1; j < len; ++j) {
                    String c = chars[j];
                    if (c.equals("(")) {
                        ++counter;
                    } else if (c.equals(")")) {
                        --counter;
                    }
                    if (counter == 0) {
                        symbols.add(this.breakdownChars(buffer.split("(?!^)")));
                        i = j;
                        buffer = "";
                        continue block0;
                    }
                    buffer = buffer + c;
                }
                continue;
            }
            buffer = buffer + s;
        }
        if (!buffer.isEmpty()) {
            symbols.add(buffer);
        }
        return symbols;
    }

    public IValue parseSymbols(List<Object> symbols) throws Exception {
        int size = symbols.size();
        if (size == 1) {
            return this.valueFromObject(symbols.get(0));
        }
        if (size == 2) {
            Object first = symbols.get(0);
            Object second = symbols.get(1);
            if (this.isVariable(first) && second instanceof List) {
                return this.createFunction((String)first, (List)second);
            }
        }
        int firstOp = -1;
        int secondOp = -1;
        for (int i = 0; i < size; ++i) {
            Object o = symbols.get(i);
            if (!this.isOperator(o)) continue;
            if (firstOp == -1) {
                firstOp = i;
                continue;
            }
            secondOp = i;
            break;
        }
        Operation op = this.operationForOperator((String)symbols.get(firstOp));
        if (secondOp == -1) {
            IValue left = this.parseSymbols(symbols.subList(0, firstOp));
            IValue right = this.parseSymbols(symbols.subList(firstOp + 1, MathHelper.func_76125_a((int)(firstOp + 3), (int)0, (int)size)));
            return new Operator(op, left, right);
        }
        if (secondOp > firstOp) {
            Operation compareTo = this.operationForOperator((String)symbols.get(secondOp));
            IValue left = this.parseSymbols(symbols.subList(0, firstOp));
            if (compareTo.value > op.value) {
                return new Operator(op, left, this.parseSymbols(symbols.subList(firstOp + 1, size)));
            }
            IValue right = this.parseSymbols(symbols.subList(firstOp + 1, secondOp));
            return new Operator(compareTo, new Operator(op, left, right), this.parseSymbols(symbols.subList(secondOp + 1, size)));
        }
        throw new Exception("Given symbols couldn't be parsed! " + symbols);
    }

    private IValue createFunction(String first, List<Object> args) throws Exception {
        if (!this.functions.containsKey(first)) {
            throw new Exception("Function '" + first + "' couldn't be found!");
        }
        ArrayList<IValue> values = new ArrayList<IValue>();
        ArrayList<Object> buffer = new ArrayList<Object>();
        for (Object o : args) {
            if (o.equals(",")) {
                values.add(this.parseSymbols(buffer));
                buffer.clear();
                continue;
            }
            buffer.add(o);
        }
        if (!buffer.isEmpty()) {
            values.add(this.parseSymbols(buffer));
        }
        Class<? extends Function> function = this.functions.get(first);
        Constructor<? extends Function> ctor = function.getConstructor(IValue[].class);
        Function func = ctor.newInstance(new Object[]{values.toArray(new IValue[values.size()])});
        return func;
    }

    public IValue valueFromObject(Object object) throws Exception {
        if (object instanceof String) {
            String symbol = (String)object;
            if (this.isDecimal(symbol)) {
                return new Constant(Double.parseDouble(symbol));
            }
            if (this.isVariable(symbol)) {
                if (symbol.indexOf("-") == 0) {
                    IValue value = this.variables.get(symbol = symbol.substring(1));
                    if (value instanceof Variable) {
                        return ((Variable)value).negative;
                    }
                } else {
                    IValue value = this.variables.get(symbol);
                    if (value != null) {
                        return value;
                    }
                }
            }
        } else if (object instanceof List) {
            return new Group(this.parseSymbols((List)object));
        }
        throw new Exception("Given object couldn't be converted to value! " + object);
    }

    private Operation operationForOperator(String op) throws Exception {
        for (Operation operation : Operation.values()) {
            if (!operation.sign.equals(op)) continue;
            return operation;
        }
        throw new Exception("There is no such operator '" + op + "'!");
    }

    private boolean isVariable(Object o) {
        return o instanceof String && !this.isDecimal((String)o) && !this.isOperator((String)o);
    }

    private boolean isOperator(Object o) {
        return o instanceof String && this.isOperator((String)o);
    }

    private boolean isOperator(String s) {
        return s.equals("+") || s.equals("-") || s.equals("*") || s.equals("/") || s.equals("%") || s.equals("^");
    }

    private boolean isDecimal(String s) {
        return s.matches("^-?\\d+(\\.\\d+)?$");
    }
}

