/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;

public class ReflectionUtils {
    public static Field TEXTURE_MAP;

    public static Map<ResourceLocation, ITextureObject> getTextures(TextureManager manager) {
        if (TEXTURE_MAP == null) {
            ReflectionUtils.setupTextureMapField(manager);
        }
        try {
            return (Map)TEXTURE_MAP.get(manager);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setupTextureMapField(TextureManager manager) {
        for (Field field : manager.getClass().getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                Object value = field.get(manager);
                if (!(value instanceof Map) || !(((Map)value).keySet().iterator().next() instanceof ResourceLocation)) continue;
                TEXTURE_MAP = field;
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

