/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.utils.files.entries;

import java.io.File;
import java.util.Iterator;
import java.util.Objects;
import mchorse.mclib.utils.files.entries.AbstractEntry;
import mchorse.mclib.utils.files.entries.FileEntry;
import mchorse.mclib.utils.files.entries.FolderEntry;
import mchorse.mclib.utils.resources.RLUtils;

public class FolderImageEntry
extends FolderEntry {
    public FolderImageEntry(String title, File file, FolderEntry parent) {
        super(title, file, parent);
    }

    @Override
    protected void populateEntries() {
        String prefix = this.getPrefix();
        for (File file : this.file.listFiles()) {
            AbstractEntry entry = null;
            String name = file.getName();
            String lowercase = name.toLowerCase();
            if (file.isDirectory()) {
                entry = new FolderImageEntry(name, file, this);
            } else if (file.isFile() && (lowercase.endsWith(".png") || lowercase.endsWith(".jpg") || lowercase.endsWith(".jpeg") || lowercase.endsWith(".gif"))) {
                entry = new FileEntry(name, file, RLUtils.create(prefix + "/" + name));
            }
            if (Objects.equals(this.getEntry(name), entry) || entry == null) continue;
            this.entries.add(entry);
        }
        Iterator it = this.entries.iterator();
        while (it.hasNext()) {
            AbstractEntry entry = (AbstractEntry)it.next();
            if (entry.exists()) continue;
            it.remove();
        }
        super.populateEntries();
    }
}

