/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.utils.resources;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import mchorse.mclib.utils.resources.IResourceTransformer;
import mchorse.mclib.utils.resources.MultiResourceLocation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.SimpleResource;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RLUtils {
    private static List<IResourceTransformer> transformers = new ArrayList<IResourceTransformer>();

    @SideOnly(value=Side.CLIENT)
    public static IResource getStreamForMultiskin(MultiResourceLocation multi) throws IOException {
        if (multi.children.isEmpty()) {
            throw new IOException("Multi-skin is empty!");
        }
        try {
            IResourceManager manager = Minecraft.func_71410_x().func_110442_L();
            BufferedImage image = ImageIO.read(manager.func_110536_a(multi.children.get(0)).func_110527_b());
            Graphics g = image.getGraphics();
            for (int i = 1; i < multi.children.size(); ++i) {
                ResourceLocation child = multi.children.get(i);
                try {
                    IResource resource = manager.func_110536_a(child);
                    BufferedImage childImage = ImageIO.read(resource.func_110527_b());
                    g.drawImage(childImage, 0, 0, null);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            g.dispose();
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", stream);
            return new SimpleResource("McLib multiskin handler", (ResourceLocation)multi, (InputStream)new ByteArrayInputStream(stream.toByteArray()), null, null);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public static void register(IResourceTransformer transformer) {
        transformers.add(transformer);
    }

    public static ResourceLocation create(String path) {
        for (IResourceTransformer transformer : transformers) {
            path = transformer.transform(path);
        }
        return new ResourceLocation(path);
    }

    public static ResourceLocation create(String domain, String path) {
        for (IResourceTransformer transformer : transformers) {
            String newDomain = transformer.transformDomain(domain, path);
            String newPath = transformer.transformPath(domain, path);
            domain = newDomain;
            path = newPath;
        }
        return new ResourceLocation(domain, path);
    }

    public static ResourceLocation create(NBTBase base) {
        if (base instanceof NBTTagList) {
            NBTTagList list = (NBTTagList)base;
            if (!list.func_82582_d()) {
                MultiResourceLocation multi = new MultiResourceLocation(list.func_150307_f(0));
                for (int i = 1; i < list.func_74745_c(); ++i) {
                    multi.children.add(RLUtils.create(list.func_150307_f(i)));
                }
                return multi;
            }
        } else if (base instanceof NBTTagString) {
            return RLUtils.create(((NBTTagString)base).func_150285_a_());
        }
        return null;
    }

    public static ResourceLocation create(JsonElement jsonElement) {
        if (jsonElement.isJsonArray()) {
            JsonElement first;
            JsonArray array = jsonElement.getAsJsonArray();
            int size = array.size();
            if (size > 0 && (first = array.get(0)).isJsonPrimitive()) {
                MultiResourceLocation location = new MultiResourceLocation(first.getAsString());
                for (int i = 1; i < size; ++i) {
                    location.children.add(RLUtils.create(array.get(i)));
                }
                return location;
            }
        } else if (jsonElement.isJsonPrimitive()) {
            return RLUtils.create(jsonElement.getAsString());
        }
        return null;
    }

    public static NBTBase writeNbt(ResourceLocation location) {
        if (location instanceof MultiResourceLocation) {
            MultiResourceLocation multi = (MultiResourceLocation)location;
            NBTTagList list = new NBTTagList();
            for (ResourceLocation child : multi.children) {
                list.func_74742_a((NBTBase)new NBTTagString(child.toString()));
            }
            return list;
        }
        if (location != null) {
            return new NBTTagString(location.toString());
        }
        return null;
    }

    public static JsonElement writeJson(ResourceLocation location) {
        if (location instanceof MultiResourceLocation) {
            MultiResourceLocation multi = (MultiResourceLocation)location;
            JsonArray array = new JsonArray();
            for (ResourceLocation child : multi.children) {
                array.add((JsonElement)new JsonPrimitive(child.toString()));
            }
            return array;
        }
        if (location != null) {
            return new JsonPrimitive(location.toString());
        }
        return JsonNull.INSTANCE;
    }

    public static ResourceLocation clone(ResourceLocation location) {
        if (location instanceof MultiResourceLocation) {
            MultiResourceLocation multi = (MultiResourceLocation)location;
            MultiResourceLocation newMulti = new MultiResourceLocation(multi.toString());
            newMulti.children.clear();
            newMulti.children.addAll(multi.children);
            return newMulti;
        }
        if (location != null) {
            return RLUtils.create(location.toString());
        }
        return null;
    }
}

