/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.framework.elements;

import mchorse.mclib.client.gui.framework.GuiTooltip;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.utils.DummyEntity;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.lwjgl.util.glu.Project;

public abstract class GuiModelRenderer
extends GuiElement {
    public DummyEntity dummy;
    protected IBlockState block = Blocks.field_150349_c.func_176223_P();
    protected float scale;
    protected int timer;
    protected boolean dragging;
    protected boolean position;
    protected float yaw;
    protected float pitch;
    protected float x;
    protected float y;
    protected float lastX;
    protected float lastY;

    public GuiModelRenderer(Minecraft mc) {
        super(mc);
        this.dummy = new DummyEntity((World)mc.field_71441_e);
    }

    public void reset() {
        this.yaw = 0.0f;
        this.pitch = 0.0f;
        this.x = 0.0f;
        this.y = 0.0f;
        this.scale = 0.0f;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (super.mouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        this.dragging = true;
        this.lastX = mouseX;
        this.lastY = mouseY;
        this.position = GuiScreen.func_146272_n() || mouseButton == 2;
        return false;
    }

    @Override
    public boolean mouseScrolled(int mouseX, int mouseY, int scroll) {
        if (super.mouseScrolled(mouseX, mouseY, scroll)) {
            return true;
        }
        this.scale += Math.copySign(0.25f, scroll);
        this.scale = MathHelper.func_76131_a((float)this.scale, (float)-1.5f, (float)30.0f);
        return false;
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY, int state) {
        if (this.dragging) {
            if (this.position) {
                this.x -= (this.lastX - (float)mouseX) / 60.0f;
                this.y += (this.lastY - (float)mouseY) / 60.0f;
            } else {
                this.yaw -= this.lastX - (float)mouseX;
                this.pitch += this.lastY - (float)mouseY;
            }
        }
        this.dragging = false;
        this.position = false;
        super.mouseReleased(mouseX, mouseY, state);
    }

    @Override
    public void draw(GuiTooltip tooltip, int mouseX, int mouseY, float partialTicks) {
        super.draw(tooltip, mouseX, mouseY, partialTicks);
        this.update();
        this.drawModel(mouseX, mouseY, partialTicks);
    }

    protected void update() {
        this.dummy.field_70173_aa = this.timer = this.mc.field_71439_g != null ? this.mc.field_71439_g.field_70173_aa : this.timer + 1;
    }

    private void drawModel(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179086_m((int)256);
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179096_D();
        Project.gluPerspective((float)70.0f, (float)((float)this.mc.field_71443_c / (float)this.mc.field_71440_d), (float)0.05f, (float)1000.0f);
        GlStateManager.func_179128_n((int)5888);
        float newYaw = this.yaw;
        float newPitch = this.pitch;
        float x = this.x;
        float y = this.y;
        if (this.dragging) {
            if (this.position) {
                x -= (this.lastX - (float)mouseX) / 60.0f;
                y += (this.lastY - (float)mouseY) / 60.0f;
            } else {
                newYaw -= this.lastX - (float)mouseX;
                newPitch += this.lastY - (float)mouseY;
            }
        }
        RenderHelper.func_74519_b();
        GlStateManager.func_179141_d();
        GlStateManager.func_179091_B();
        GlStateManager.func_179126_j();
        GlStateManager.func_179129_p();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        GlStateManager.func_179109_b((float)(0.0f + x), (float)(-1.0f + y), (float)(-2.0f - this.scale));
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)(180.0f + newYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)newPitch, (float)1.0f, (float)0.0f, (float)0.0f);
        this.drawGround();
        this.drawModel(newYaw, newPitch, mouseX, mouseY, partialTicks);
        GlStateManager.func_179121_F();
        GlStateManager.func_179089_o();
        GlStateManager.func_179097_i();
        GlStateManager.func_179101_C();
        GlStateManager.func_179118_c();
        RenderHelper.func_74518_a();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GuiScreen screen = this.mc.field_71462_r;
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179096_D();
        GlStateManager.func_179130_a((double)0.0, (double)screen.field_146294_l, (double)screen.field_146295_m, (double)0.0, (double)1000.0, (double)3000000.0);
        GlStateManager.func_179128_n((int)5888);
    }

    protected abstract void drawModel(float var1, float var2, int var3, int var4, float var5);

    protected void drawGround() {
        BlockRendererDispatcher renderer = this.mc.func_175602_ab();
        this.mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)-0.5f, (float)0.0f);
        GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)0.5f);
        renderer.func_175016_a(this.block, 1.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }
}

