/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.utils;

import mchorse.mclib.client.gui.utils.Area;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.math.MathHelper;

public class ScrollArea
extends Area {
    public int scrollItemSize;
    public int scrollSize;
    public int scroll;
    public boolean dragging;
    public int scrollSpeed = 5;
    public ScrollDirection direction = ScrollDirection.VERTICAL;

    public ScrollArea(int itemSize) {
        this.scrollItemSize = itemSize;
    }

    public void setSize(int items) {
        this.scrollSize = items * this.scrollItemSize;
    }

    public void scrollBy(int x) {
        this.scroll += x;
        this.clamp();
    }

    public void scrollTo(int x) {
        this.scroll = x;
        this.clamp();
    }

    public void scrollIntoView(int x) {
        this.scrollIntoView(x, this.scrollItemSize);
    }

    public void scrollIntoView(int x, int bottomOffset) {
        if (this.scroll > x) {
            this.scrollTo(x);
        } else if (x > this.scroll + this.direction.getSide(this) - bottomOffset) {
            this.scrollTo(x - this.direction.getSide(this) + bottomOffset);
        }
    }

    public void clamp() {
        int size = this.direction.getSide(this);
        this.scroll = this.scrollSize <= size ? 0 : MathHelper.func_76125_a((int)this.scroll, (int)0, (int)(this.scrollSize - size));
    }

    public int getIndex(int x, int y) {
        int axis = this.direction.getScroll(this, x, y);
        int index = axis / this.scrollItemSize;
        if (axis < 0 || axis > this.scrollSize) {
            return -1;
        }
        return index > this.scrollSize / this.scrollItemSize ? -1 : index;
    }

    public int getScrollBar(int size) {
        int maxSize = this.direction.getSide(this);
        if (this.scrollSize < size) {
            return 0;
        }
        return (int)((1.0f - (float)(this.scrollSize - maxSize) / (float)this.scrollSize) * (float)size);
    }

    public boolean mouseClicked(int x, int y) {
        boolean isInside;
        boolean bl = this.isInside(x, y) && this.scrollSize > this.h && (this.direction == ScrollDirection.VERTICAL ? x >= this.getX(1.0f) - 4 : y >= this.getY(1.0f) - 4) ? true : (isInside = false);
        if (isInside) {
            this.dragging = true;
        }
        return isInside;
    }

    public boolean mouseScroll(int x, int y, int scroll) {
        boolean isInside = this.isInside(x, y);
        if (isInside) {
            this.scrollBy((int)Math.copySign(this.scrollSpeed, scroll));
        }
        return isInside;
    }

    public void mouseReleased(int x, int y) {
        this.dragging = false;
    }

    public void drag(int x, int y) {
        if (this.dragging) {
            float progress = this.direction.getProgress(this, x, y);
            this.scrollTo((int)(progress * (float)(this.scrollSize - this.direction.getSide(this) + 4)));
        }
    }

    public void drawScrollbar() {
        int side = this.direction.getSide(this);
        if (this.scrollSize <= side) {
            return;
        }
        int h = this.getScrollBar(side / 2);
        int x = this.getX(1.0f) - 4;
        int y = this.y + (int)((float)this.scroll / (float)(this.scrollSize - this.h) * (float)(this.h - h));
        if (this.direction == ScrollDirection.HORIZONTAL) {
            y = this.getY(1.0f) - 4;
            x = this.x + (int)((float)this.scroll / (float)(this.scrollSize - this.w) * (float)(this.w - h));
            Gui.func_73734_a((int)x, (int)y, (int)(x + h), (int)(y + 4), (int)-6250336);
        } else {
            Gui.func_73734_a((int)x, (int)y, (int)(x + 4), (int)(y + h), (int)-6250336);
        }
    }

    public static enum ScrollDirection {
        VERTICAL{

            @Override
            public int getSide(ScrollArea area) {
                return area.h;
            }

            @Override
            public int getScroll(ScrollArea area, int x, int y) {
                return y - area.y + area.scroll;
            }

            @Override
            public float getProgress(ScrollArea area, int x, int y) {
                return (float)(y - area.y) / (float)area.h;
            }
        }
        ,
        HORIZONTAL{

            @Override
            public int getSide(ScrollArea area) {
                return area.w;
            }

            @Override
            public int getScroll(ScrollArea area, int x, int y) {
                return x - area.x + area.scroll;
            }

            @Override
            public float getProgress(ScrollArea area, int x, int y) {
                return (float)(x - area.x) / (float)area.w;
            }
        };


        public abstract int getSide(ScrollArea var1);

        public abstract int getScroll(ScrollArea var1, int var2, int var3);

        public abstract float getProgress(ScrollArea var1, int var2, int var3);
    }
}

