/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.math;

public enum Operation {
    ADD("+", 1){

        @Override
        public double calculate(double a, double b) {
            return a + b;
        }
    }
    ,
    SUB("-", 1){

        @Override
        public double calculate(double a, double b) {
            return a - b;
        }
    }
    ,
    MUL("*", 2){

        @Override
        public double calculate(double a, double b) {
            return a * b;
        }
    }
    ,
    DIV("/", 2){

        @Override
        public double calculate(double a, double b) {
            return a / (b == 0.0 ? 1.0 : b);
        }
    }
    ,
    MOD("%", 2){

        @Override
        public double calculate(double a, double b) {
            return a % b;
        }
    }
    ,
    POW("^", 3){

        @Override
        public double calculate(double a, double b) {
            return Math.pow(a, b);
        }
    };

    public final String sign;
    public final int value;

    private Operation(String sign, int value) {
        this.sign = sign;
        this.value = value;
    }

    public abstract double calculate(double var1, double var3);
}

