/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.math.functions;

import mchorse.mclib.math.IValue;

public abstract class Function
implements IValue {
    protected IValue[] args;

    public Function(IValue[] values) throws Exception {
        if (values.length < this.getRequiredArguments()) {
            String message = String.format("Function '%s' requires at least %s arguments. %s are given!", this.getName(), this.getRequiredArguments(), values.length);
            throw new Exception(message);
        }
        this.args = values;
    }

    public double getArg(int index) {
        if (index < 0 || index >= this.args.length) {
            return 0.0;
        }
        return this.args[index].get();
    }

    public String toString() {
        String args = "";
        for (int i = 0; i < this.args.length; ++i) {
            args = args + this.args[i].toString();
            if (i >= this.args.length - 1) continue;
            args = args + ", ";
        }
        return this.getName() + "(" + args + ")";
    }

    public abstract String getName();

    public int getRequiredArguments() {
        return 0;
    }
}

