/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph;

import java.lang.reflect.Field;
import java.util.Map;
import mchorse.metamorph.CommonProxy;
import mchorse.metamorph.Metamorph;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.client.KeyboardHandler;
import mchorse.metamorph.client.NetworkHandler;
import mchorse.metamorph.client.RenderingHandler;
import mchorse.metamorph.client.gui.elements.GuiHud;
import mchorse.metamorph.client.gui.elements.GuiOverlay;
import mchorse.metamorph.client.render.RenderMorph;
import mchorse.metamorph.entity.EntityMorph;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.RenderSubPlayer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.GameType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    public static GuiOverlay morphOverlay = new GuiOverlay();
    public static GuiHud hud = new GuiHud();
    public static KeyboardHandler keys;

    @Override
    public void preLoad(FMLPreInitializationEvent event) {
        super.preLoad(event);
        RenderingRegistry.registerEntityRenderingHandler(EntityMorph.class, (IRenderFactory)new RenderMorph.MorphFactory());
        Metamorph.channel.register((Object)new NetworkHandler());
    }

    @Override
    public void load() {
        super.load();
        MinecraftForge.EVENT_BUS.register((Object)new RenderingHandler(morphOverlay, hud));
        keys = new KeyboardHandler();
        MinecraftForge.EVENT_BUS.register((Object)keys);
        MorphManager.INSTANCE.registerClient();
    }

    @Override
    public void postLoad(FMLPostInitializationEvent event) {
        super.postLoad(event);
        RenderManager manager = Minecraft.func_71410_x().func_175598_ae();
        this.substitutePlayerRenderers(manager);
    }

    private void substitutePlayerRenderers(RenderManager manager) {
        Map skins = null;
        for (Field field : manager.getClass().getDeclaredFields()) {
            if (!field.getType().equals(Map.class)) continue;
            field.setAccessible(true);
            try {
                Map map = (Map)field.get(manager);
                if (!(map.get("default") instanceof RenderPlayer)) continue;
                skins = map;
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (skins != null) {
            RenderPlayer slim = (RenderPlayer)skins.get("slim");
            RenderPlayer def = (RenderPlayer)skins.get("default");
            skins.put("slim", new RenderSubPlayer(manager, slim, true));
            skins.put("default", new RenderSubPlayer(manager, def, false));
            Metamorph.log("Skin map renderers were successfully replaced with Metamorph substitutes!");
        }
    }

    public static GameType getGameMode(EntityPlayer player) {
        NetworkPlayerInfo networkplayerinfo = Minecraft.func_71410_x().func_147114_u().func_175102_a(player.func_146103_bH().getId());
        return networkplayerinfo != null ? networkplayerinfo.func_178848_b() : GameType.CREATIVE;
    }
}

