/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.api;

import mchorse.metamorph.Metamorph;
import mchorse.metamorph.api.EntityUtils;
import mchorse.metamorph.api.events.AcquireMorphEvent;
import mchorse.metamorph.api.events.MorphEvent;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.capabilities.morphing.IMorphing;
import mchorse.metamorph.capabilities.morphing.Morphing;
import mchorse.metamorph.network.Dispatcher;
import mchorse.metamorph.network.common.PacketAcquireMorph;
import mchorse.metamorph.network.common.PacketMorph;
import mchorse.metamorph.network.common.PacketMorphPlayer;
import mchorse.metamorph.network.common.PacketMorphState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChat;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class MorphAPI {
    public static boolean demorph(EntityPlayer player) {
        return MorphAPI.morph(player, null, false);
    }

    public static boolean morph(EntityPlayer player, AbstractMorph morph, boolean force) {
        IMorphing morphing = Morphing.get(player);
        if (morphing == null) {
            return false;
        }
        if (!(force || player.field_70145_X || Metamorph.proxy.config.morph_in_tight_spaces || EntityUtils.canPlayerMorphFit(player, morphing.getCurrentMorph(), morph))) {
            if (!player.field_70170_p.field_72995_K) {
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketChat((ITextComponent)new TextComponentTranslation("metamorph.gui.status.tight_space", new Object[0]), 2));
            }
            return false;
        }
        MorphEvent.Pre event = new MorphEvent.Pre(player, morph, force);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        boolean morphed = morphing.setCurrentMorph(event.morph, player, event.force);
        if (!player.field_70170_p.field_72995_K && morphed) {
            Dispatcher.sendTo(new PacketMorph(morph), (EntityPlayerMP)player);
            Dispatcher.sendToTracked((Entity)player, new PacketMorphPlayer(player.func_145782_y(), morph));
            Dispatcher.sendTo(new PacketMorphState(player, morphing), (EntityPlayerMP)player);
        }
        if (morphed) {
            MinecraftForge.EVENT_BUS.post((Event)new MorphEvent.Post(player, event.morph, force));
        }
        return morphed;
    }

    public static boolean acquire(EntityPlayer player, AbstractMorph morph) {
        if (morph == null) {
            return false;
        }
        AcquireMorphEvent.Pre event = new AcquireMorphEvent.Pre(player, morph);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        boolean acquired = Morphing.get(player).acquireMorph(event.morph);
        if (!player.field_70170_p.field_72995_K && acquired) {
            Dispatcher.sendTo(new PacketAcquireMorph(event.morph), (EntityPlayerMP)player);
        }
        if (acquired) {
            MinecraftForge.EVENT_BUS.post((Event)new AcquireMorphEvent.Post(player, event.morph));
        }
        return acquired;
    }
}

