/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.api;

import java.util.ArrayList;
import java.util.List;
import mchorse.metamorph.ClientProxy;
import mchorse.metamorph.Metamorph;
import mchorse.metamorph.api.EntityUtils;
import mchorse.metamorph.api.MorphAPI;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.events.SpawnGhostEvent;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.api.morphs.EntityMorph;
import mchorse.metamorph.capabilities.morphing.IMorphing;
import mchorse.metamorph.capabilities.morphing.Morphing;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class MorphHandler {
    public static List<Runnable> FUTURE_TASKS_CLIENT = new ArrayList<Runnable>();
    public static List<Runnable> FUTURE_TASKS_SERVER = new ArrayList<Runnable>();

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        block7: {
            float maxHealth;
            if (event.phase == TickEvent.Phase.START) {
                return;
            }
            EntityPlayer player = event.player;
            IMorphing capability = Morphing.get(player);
            this.runFutureTasks(player);
            if (capability != null && (maxHealth = player.func_110138_aP()) > 1.4E-43f) {
                float healthRatio = player.func_110143_aJ() / maxHealth;
                capability.setLastHealthRatio(healthRatio);
            }
            if (!(capability != null && capability.isMorphed() || Metamorph.proxy.config.disable_pov)) {
                player.eyeHeight = player.getDefaultEyeHeight();
            }
            if (player.field_70170_p.field_72995_K) {
                boolean hasSquidAir = false;
                int squidAir = 300;
                if (capability != null) {
                    hasSquidAir = capability.getHasSquidAir();
                    squidAir = capability.getSquidAir();
                }
                ClientProxy.hud.renderSquidAir = hasSquidAir;
                ClientProxy.hud.squidAir = squidAir;
            }
            try {
                capability.update(player);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (player.field_70170_p.field_72995_K) break block7;
                MorphAPI.demorph(player);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerKillEntity(LivingDeathEvent event) {
        Entity source = event.getSource().func_76346_g();
        Entity target = event.getEntity();
        if (target.field_70170_p.field_72995_K || source instanceof FakePlayer) {
            return;
        }
        if (!(source instanceof EntityPlayer) || target instanceof EntityPlayer || Metamorph.proxy.config.prevent_kill_acquire) {
            return;
        }
        EntityPlayer player = (EntityPlayer)source;
        IMorphing capability = Morphing.get(player);
        if (capability == null) {
            return;
        }
        String name = MorphManager.INSTANCE.morphNameFromEntity(target);
        if (!MorphManager.INSTANCE.hasMorph(name)) {
            Metamorph.log("Morph by key '" + name + "' doesn't exist!");
            return;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Name", name);
        tag.func_74782_a("EntityData", (NBTBase)EntityUtils.stripEntityNBT(target.serializeNBT()));
        AbstractMorph morph = MorphManager.INSTANCE.morphFromNBT(tag);
        boolean acquired = capability.acquiredMorph(morph);
        if (Metamorph.proxy.config.acquire_immediately && !acquired) {
            MorphAPI.acquire(player, morph);
            return;
        }
        if (!Metamorph.proxy.config.prevent_ghosts || !acquired) {
            SpawnGhostEvent.Pre spawnGhostEvent = new SpawnGhostEvent.Pre(player, morph);
            if (MinecraftForge.EVENT_BUS.post((Event)spawnGhostEvent) || spawnGhostEvent.morph == null) {
                return;
            }
            morph = spawnGhostEvent.morph;
            mchorse.metamorph.entity.EntityMorph morphEntity = new mchorse.metamorph.entity.EntityMorph(player.field_70170_p, player.func_110124_au(), morph);
            morphEntity.func_70080_a(target.field_70165_t, target.field_70163_u + (double)(target.field_70131_O / 2.0f), target.field_70161_v, target.field_70177_z, target.field_70125_A);
            player.field_70170_p.func_72838_d((Entity)morphEntity);
            MinecraftForge.EVENT_BUS.post((Event)new SpawnGhostEvent.Post(player, morph));
        }
    }

    @SubscribeEvent
    public void onMorphAttackPlayer(LivingAttackEvent event) {
        Entity target = event.getEntity();
        if (target instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)target;
            IMorphing capability = Morphing.get(player);
            if (capability == null || !capability.isMorphed()) {
                return;
            }
            AbstractMorph morph = capability.getCurrentMorph();
            if (morph == null || !(morph instanceof EntityMorph)) {
                return;
            }
            EntityMorph entityMorph = (EntityMorph)morph;
            if (entityMorph.isUpdatingEntity()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerAttack(LivingAttackEvent event) {
        Entity source = event.getSource().func_76346_g();
        Entity target = event.getEntity();
        if (source instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)source;
            IMorphing capability = Morphing.get(player);
            if (capability == null || !capability.isMorphed()) {
                return;
            }
            capability.getCurrentMorph().attack(target, (EntityLivingBase)player);
        }
    }

    @SubscribeEvent
    public void onLivingSetAttackTarget(LivingSetAttackTargetEvent event) {
        if (Metamorph.proxy.config.disable_morph_disguise) {
            return;
        }
        EntityLivingBase target = event.getTarget();
        EntityLivingBase source = event.getEntityLiving();
        if (target instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)target;
            IMorphing morphing = Morphing.get(player);
            if (morphing == null || !morphing.isMorphed()) {
                return;
            }
            if (morphing.getCurrentMorph().settings.hostile && source.func_94060_bK() != target && source instanceof EntityLiving) {
                ((EntityLiving)event.getEntity()).func_70624_b(null);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        IMorphing capability = Morphing.get(event.player);
        if (capability != null && capability.getCurrentMorph() != null) {
            capability.getCurrentMorph().onChangeDimension(event.player, event.fromDim, event.toDim);
        }
    }

    private void runFutureTasks(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K && !FUTURE_TASKS_CLIENT.isEmpty()) {
            FUTURE_TASKS_CLIENT.remove(0).run();
        }
        if (!player.field_70170_p.field_72995_K && !FUTURE_TASKS_SERVER.isEmpty()) {
            FUTURE_TASKS_SERVER.remove(0).run();
        }
    }
}

