/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import mchorse.metamorph.api.IMorphFactory;
import mchorse.metamorph.api.MorphList;
import mchorse.metamorph.api.MorphSettings;
import mchorse.metamorph.api.abilities.IAbility;
import mchorse.metamorph.api.abilities.IAction;
import mchorse.metamorph.api.abilities.IAttackAbility;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.api.morphs.EntityMorph;
import mchorse.metamorph.client.gui.editor.GuiAbstractMorph;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MorphManager {
    public static final MorphManager INSTANCE = new MorphManager();
    public static final Map<String, ResourceLocation> NAME_TO_RL = new HashMap<String, ResourceLocation>();
    public Map<String, IAbility> abilities = new HashMap<String, IAbility>();
    public Map<String, IAction> actions = new HashMap<String, IAction>();
    public Map<String, IAttackAbility> attacks = new HashMap<String, IAttackAbility>();
    public List<IMorphFactory> factories = new ArrayList<IMorphFactory>();
    public Map<String, MorphSettings> activeSettings = new HashMap<String, MorphSettings>();
    public Set<String> activeBlacklist = new TreeSet<String>();

    public static void initiateMap() {
        for (EntityEntry entity : ForgeRegistries.ENTITIES.getValues()) {
            NAME_TO_RL.put(entity.getName(), entity.getRegistryName());
        }
    }

    public static boolean isBlacklisted(String name) {
        return MorphManager.INSTANCE.activeBlacklist.contains(name);
    }

    public void setActiveBlacklist(Set<String> blacklist) {
        this.activeBlacklist.clear();
        this.activeBlacklist.addAll(blacklist);
    }

    public void setActiveSettings(Map<String, MorphSettings> settings) {
        HashMap<String, MorphSettings> newSettings = new HashMap<String, MorphSettings>();
        for (Map.Entry<String, MorphSettings> entry : settings.entrySet()) {
            String key = entry.getKey();
            MorphSettings setting = this.activeSettings.get(key);
            if (setting == null) {
                setting = entry.getValue();
            } else {
                setting.merge(entry.getValue());
            }
            newSettings.put(key, setting);
        }
        this.activeSettings.clear();
        this.activeSettings.putAll(newSettings);
    }

    private MorphManager() {
    }

    public void register() {
        for (int i = this.factories.size() - 1; i >= 0; --i) {
            this.factories.get(i).register(this);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerClient() {
        for (int i = this.factories.size() - 1; i >= 0; --i) {
            this.factories.get(i).registerClient(this);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerMorphEditors(List<GuiAbstractMorph> editors) {
        for (int i = this.factories.size() - 1; i >= 0; --i) {
            this.factories.get(i).registerMorphEditors(editors);
        }
    }

    public boolean hasMorph(String name) {
        if (MorphManager.isBlacklisted(name)) {
            return false;
        }
        for (int i = this.factories.size() - 1; i >= 0; --i) {
            if (!this.factories.get(i).hasMorph(name)) continue;
            return true;
        }
        return false;
    }

    public AbstractMorph morphFromNBT(NBTTagCompound tag) {
        String name = tag.func_74779_i("Name");
        if (MorphManager.isBlacklisted(name)) {
            return null;
        }
        for (int i = this.factories.size() - 1; i >= 0; --i) {
            if (!this.factories.get(i).hasMorph(name)) continue;
            AbstractMorph morph = this.factories.get(i).getMorphFromNBT(tag);
            this.applySettings(morph);
            return morph;
        }
        return null;
    }

    public void applySettings(AbstractMorph morph) {
        if (this.activeSettings.containsKey(morph.name)) {
            morph.settings = this.activeSettings.get(morph.name);
        }
    }

    public MorphList getMorphs(World world) {
        MorphList morphs = new MorphList();
        for (int i = this.factories.size() - 1; i >= 0; --i) {
            this.factories.get(i).getMorphs(morphs, world);
        }
        return morphs;
    }

    public String morphNameFromEntity(Entity entity) {
        return EntityList.func_191301_a((Entity)entity).toString();
    }

    @SideOnly(value=Side.CLIENT)
    public String morphDisplayNameFromMorph(AbstractMorph morph) {
        for (int i = this.factories.size() - 1; i >= 0; --i) {
            String name2 = this.factories.get(i).displayNameForMorph(morph);
            if (name2 == null) continue;
            return name2;
        }
        String name = morph.name;
        try {
            if (morph instanceof EntityMorph) {
                name = EntityList.func_75621_b((Entity)((EntityMorph)morph).getEntity((World)Minecraft.func_71410_x().field_71441_e));
            }
        }
        catch (Exception name2) {
            // empty catch block
        }
        String key = "entity." + name + ".name";
        String result = I18n.func_135052_a((String)key, (Object[])new Object[0]);
        return key.equals(result) ? name : result;
    }
}

