/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.bodypart;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import mchorse.mclib.client.gui.framework.GuiTooltip;
import mchorse.mclib.client.gui.framework.elements.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.GuiElements;
import mchorse.mclib.client.gui.framework.elements.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiListElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiStringListElement;
import mchorse.mclib.client.gui.utils.Area;
import mchorse.mclib.client.gui.widgets.GuiInventory;
import mchorse.mclib.client.gui.widgets.GuiSlot;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.bodypart.BodyPart;
import mchorse.metamorph.bodypart.BodyPartManager;
import mchorse.metamorph.bodypart.IBodyPartProvider;
import mchorse.metamorph.bodypart.MorphBodyPart;
import mchorse.metamorph.capabilities.morphing.IMorphing;
import mchorse.metamorph.capabilities.morphing.Morphing;
import mchorse.metamorph.client.gui.editor.GuiAbstractMorph;
import mchorse.metamorph.client.gui.editor.GuiMorphPanel;
import mchorse.metamorph.client.gui.elements.GuiCreativeMorphs;
import mchorse.metamorph.client.gui.elements.GuiCreativeMorphsMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiBodyPartEditor
extends GuiMorphPanel<AbstractMorph, GuiAbstractMorph>
implements GuiInventory.IInventoryPicker {
    protected GuiBodyPartListElement bodyParts;
    protected GuiButtonElement<GuiButton> pickMorph;
    protected GuiButtonElement<GuiCheckBox> useTarget;
    protected GuiCreativeMorphs morphPicker;
    protected GuiButtonElement<GuiButton> addPart;
    protected GuiButtonElement<GuiButton> removePart;
    protected GuiTrackpadElement tx;
    protected GuiTrackpadElement ty;
    protected GuiTrackpadElement tz;
    protected GuiTrackpadElement sx;
    protected GuiTrackpadElement sy;
    protected GuiTrackpadElement sz;
    protected GuiTrackpadElement rx;
    protected GuiTrackpadElement ry;
    protected GuiTrackpadElement rz;
    protected GuiStringListElement limbs;
    protected GuiElements<IGuiElement> elements = new GuiElements();
    protected BodyPartManager parts;
    protected BodyPart part;
    protected GuiInventory inventory;
    protected GuiSlot[] slots = new GuiSlot[6];
    protected GuiSlot active;

    public GuiBodyPartEditor(Minecraft mc, GuiAbstractMorph editor) {
        super(mc, editor);
        this.createChildren();
        this.tx = new GuiTrackpadElement(mc, I18n.func_135052_a((String)"metamorph.gui.x", (Object[])new Object[0]), value -> {
            this.part.part.translate[0] = value.floatValue();
        });
        this.ty = new GuiTrackpadElement(mc, I18n.func_135052_a((String)"metamorph.gui.y", (Object[])new Object[0]), value -> {
            this.part.part.translate[1] = value.floatValue();
        });
        this.tz = new GuiTrackpadElement(mc, I18n.func_135052_a((String)"metamorph.gui.z", (Object[])new Object[0]), value -> {
            this.part.part.translate[2] = value.floatValue();
        });
        this.sx = new GuiTrackpadElement(mc, I18n.func_135052_a((String)"metamorph.gui.x", (Object[])new Object[0]), value -> {
            this.part.part.scale[0] = value.floatValue();
        });
        this.sy = new GuiTrackpadElement(mc, I18n.func_135052_a((String)"metamorph.gui.y", (Object[])new Object[0]), value -> {
            this.part.part.scale[1] = value.floatValue();
        });
        this.sz = new GuiTrackpadElement(mc, I18n.func_135052_a((String)"metamorph.gui.z", (Object[])new Object[0]), value -> {
            this.part.part.scale[2] = value.floatValue();
        });
        this.rx = new GuiTrackpadElement(mc, I18n.func_135052_a((String)"metamorph.gui.x", (Object[])new Object[0]), value -> {
            this.part.part.rotate[0] = value.floatValue();
        });
        this.ry = new GuiTrackpadElement(mc, I18n.func_135052_a((String)"metamorph.gui.y", (Object[])new Object[0]), value -> {
            this.part.part.rotate[1] = value.floatValue();
        });
        this.rz = new GuiTrackpadElement(mc, I18n.func_135052_a((String)"metamorph.gui.z", (Object[])new Object[0]), value -> {
            this.part.part.rotate[2] = value.floatValue();
        });
        this.tx.resizer().set(0.0f, 35.0f, 60.0f, 20.0f).parent(this.area).x(0.5f, -95).y(1.0f, -80);
        this.ty.resizer().set(0.0f, 25.0f, 60.0f, 20.0f).relative(this.tx.resizer());
        this.tz.resizer().set(0.0f, 25.0f, 60.0f, 20.0f).relative(this.ty.resizer());
        this.sx.resizer().set(65.0f, 0.0f, 60.0f, 20.0f).relative(this.tx.resizer());
        this.sy.resizer().set(0.0f, 25.0f, 60.0f, 20.0f).relative(this.sx.resizer());
        this.sz.resizer().set(0.0f, 25.0f, 60.0f, 20.0f).relative(this.sy.resizer());
        this.rx.resizer().set(65.0f, 0.0f, 60.0f, 20.0f).relative(this.sx.resizer());
        this.ry.resizer().set(0.0f, 25.0f, 60.0f, 20.0f).relative(this.rx.resizer());
        this.rz.resizer().set(0.0f, 25.0f, 60.0f, 20.0f).relative(this.ry.resizer());
        this.limbs = new GuiStringListElement(mc, str -> this.pickLimb((String)str));
        this.bodyParts = new GuiBodyPartListElement(mc, part -> this.setPart((BodyPart)part));
        this.pickMorph = GuiButtonElement.button((Minecraft)mc, (String)I18n.func_135052_a((String)"metamorph.gui.pick", (Object[])new Object[0]), b -> {
            if (this.morphPicker == null) {
                IMorphing morphing = Morphing.get((EntityPlayer)this.mc.field_71439_g);
                this.morphPicker = new GuiCreativeMorphsMenu(mc, 6, null, morphing);
                this.morphPicker.resizer().parent(this.area).set(0.0f, 0.0f, 0.0f, 0.0f).w(1.0f, 0).h(1.0f, 0);
                this.morphPicker.callback = morph -> {
                    if (this.part != null) {
                        this.part.part.morph.setDirect((AbstractMorph)morph);
                    }
                };
                GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
                this.morphPicker.resize(screen.field_146294_l, screen.field_146295_m);
                this.children.add((IGuiElement)this.morphPicker);
            }
            this.children.unfocus();
            this.morphPicker.setSelected(this.part.part.morph.get());
            this.morphPicker.setVisible(true);
        });
        this.addPart = GuiButtonElement.button((Minecraft)mc, (String)I18n.func_135052_a((String)"metamorph.gui.add", (Object[])new Object[0]), b -> {
            BodyPart part = (BodyPart)this.bodyParts.getCurrent();
            String limb = (String)this.limbs.getCurrent();
            if (part == null) {
                part = new BodyPart();
                part.part = new MorphBodyPart();
                if (limb != null) {
                    part.limb = limb;
                }
            } else {
                part = part.clone(true);
            }
            part.init();
            this.parts.parts.add(part);
            this.bodyParts.update();
            this.bodyParts.setCurrent(part);
            this.part = part;
            this.setPart(part);
        });
        this.removePart = GuiButtonElement.button((Minecraft)mc, (String)I18n.func_135052_a((String)"metamorph.gui.remove", (Object[])new Object[0]), b -> {
            if (this.part == null) {
                return;
            }
            List<BodyPart> parts = this.parts.parts;
            int index = parts.indexOf(this.part);
            if (index != -1) {
                parts.remove(this.part);
                this.bodyParts.update();
                --index;
                if (parts.size() >= 1) {
                    this.setPart(parts.get(index >= 0 ? index : 0));
                } else {
                    this.setPart(null);
                }
            }
        });
        this.useTarget = GuiButtonElement.checkbox((Minecraft)mc, (String)I18n.func_135052_a((String)"metamorph.gui.use_target", (Object[])new Object[0]), (boolean)false, b -> {
            if (this.part != null) {
                this.part.part.useTarget = ((GuiCheckBox)b.button).isChecked();
            }
        });
        this.limbs.resizer().parent(this.area).set(0.0f, 80.0f, 105.0f, 90.0f).x(1.0f, -115).h(1.0f, -106);
        this.pickMorph.resizer().parent(this.area).set(0.0f, 40.0f, 105.0f, 20.0f).x(1.0f, -115);
        this.addPart.resizer().parent(this.area).set(10.0f, 10.0f, 50.0f, 20.0f);
        this.removePart.resizer().relative(this.addPart.resizer()).set(55.0f, 0.0f, 50.0f, 20.0f);
        this.bodyParts.resizer().parent(this.area).set(10.0f, 50.0f, 105.0f, 0.0f).h(1.0f, -55);
        this.useTarget.resizer().parent(this.area).set(0.0f, 0.0f, 60.0f, 11.0f).x(1.0f, -115).y(1.0f, -21);
        this.elements.add(new IGuiElement[]{this.tx, this.ty, this.tz, this.sx, this.sy, this.sz, this.rx, this.ry, this.rz, this.limbs, this.pickMorph, this.useTarget});
        this.children.add(new IGuiElement[]{this.addPart, this.removePart, this.bodyParts, this.elements});
        this.inventory = new GuiInventory((GuiInventory.IInventoryPicker)this, (EntityPlayer)mc.field_71439_g);
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = new GuiSlot(i);
        }
    }

    public void pickItem(GuiInventory inventory, ItemStack stack) {
        if (this.active != null) {
            this.part.part.slots[this.active.slot] = this.active.stack = stack.func_190926_b() ? ItemStack.field_190927_a : stack.func_77946_l();
            this.inventory.visible = false;
            this.part.part.updateEntity();
        }
    }

    public void resize(int width, int height) {
        super.resize(width, height);
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i].update(this.area.getX(0.5f) + 30 * i - 85, this.area.y + 10);
        }
        this.inventory.update(this.area.getX(0.5f), this.area.getY(0.5f) - 40);
        if (this.morphPicker != null) {
            this.morphPicker.setPerRow((int)Math.ceil((float)this.morphPicker.area.w / 50.0f));
        }
    }

    @Override
    public void fillData(AbstractMorph morph) {
        super.fillData(morph);
        if (morph instanceof IBodyPartProvider) {
            BodyPartManager manager = ((IBodyPartProvider)((Object)morph)).getBodyPart();
            this.startEditing(manager);
        }
    }

    public void setLimbs(Collection<String> limbs) {
        this.limbs.clear();
        this.limbs.add(limbs);
        this.limbs.sort();
    }

    public void startEditing(BodyPartManager manager) {
        this.inventory.player = this.mc.field_71439_g;
        this.parts = manager;
        this.bodyParts.setList(manager.parts);
        this.bodyParts.update();
        this.setPart(manager.parts.isEmpty() ? null : manager.parts.get(0));
    }

    public void setupBodyEditor() {
        this.bodyParts.update();
        this.setPart(this.parts.parts.isEmpty() ? null : this.parts.parts.get(0));
    }

    protected void setPart(BodyPart part) {
        this.part = part;
        this.elements.setVisible(part != null);
        if (this.part != null) {
            this.fillBodyPart(part.part);
            this.limbs.setCurrent((Object)part.limb);
            this.bodyParts.setCurrent(part);
        }
    }

    protected void pickLimb(String str) {
        this.part.limb = str;
    }

    public void fillBodyPart(MorphBodyPart part) {
        if (part != null) {
            this.tx.trackpad.setValue(part.translate[0]);
            this.ty.trackpad.setValue(part.translate[1]);
            this.tz.trackpad.setValue(part.translate[2]);
            this.sx.trackpad.setValue(part.scale[0]);
            this.sy.trackpad.setValue(part.scale[1]);
            this.sz.trackpad.setValue(part.scale[2]);
            this.rx.trackpad.setValue(part.rotate[0]);
            this.ry.trackpad.setValue(part.rotate[1]);
            this.rz.trackpad.setValue(part.rotate[2]);
            ((GuiCheckBox)this.useTarget.button).setIsChecked(part.useTarget);
            for (int i = 0; i < this.slots.length; ++i) {
                this.slots[i].stack = part.slots[i];
            }
        }
    }

    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (super.mouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.elements.isVisible()) {
            this.inventory.mouseClicked(mouseX, mouseY, mouseButton);
            this.active = null;
            for (GuiSlot slot : this.slots) {
                if (!slot.area.isInside(mouseX, mouseY)) continue;
                this.active = slot;
                this.inventory.visible = true;
            }
            if (this.active != null || this.inventory.visible && this.inventory.area.isInside(mouseX, mouseY)) {
                return true;
            }
        }
        return false;
    }

    public void draw(GuiTooltip tooltip, int mouseX, int mouseY, float partialTicks) {
        if (this.elements.isVisible()) {
            for (GuiSlot slot : this.slots) {
                slot.draw(mouseX, mouseY, partialTicks);
            }
            if (this.active != null) {
                Area a = this.active.area;
                Gui.func_73734_a((int)a.x, (int)a.y, (int)(a.x + a.w), (int)(a.y + a.h), (int)-2013230849);
            }
            this.inventory.draw(mouseX, mouseY, partialTicks);
        }
        Gui.func_73734_a((int)this.bodyParts.area.x, (int)this.bodyParts.area.y, (int)this.bodyParts.area.getX(1.0f), (int)this.bodyParts.area.getY(1.0f), (int)-2013265920);
        this.font.func_175063_a(I18n.func_135052_a((String)"metamorph.gui.body_parts", (Object[])new Object[0]), (float)this.bodyParts.area.x, (float)(this.bodyParts.area.y - 12), 0xFFFFFF);
        if (this.elements.isVisible()) {
            Gui.func_73734_a((int)this.limbs.area.x, (int)this.limbs.area.y, (int)this.limbs.area.getX(1.0f), (int)this.limbs.area.getY(1.0f), (int)-2013265920);
            this.font.func_175063_a(I18n.func_135052_a((String)"metamorph.gui.limbs", (Object[])new Object[0]), (float)this.limbs.area.x, (float)(this.limbs.area.y - 12), 0xFFFFFF);
            this.font.func_175063_a(I18n.func_135052_a((String)"metamorph.gui.translate", (Object[])new Object[0]), (float)this.tx.area.x, (float)(this.tx.area.y - 12), 0xFFFFFF);
            this.font.func_175063_a(I18n.func_135052_a((String)"metamorph.gui.scale", (Object[])new Object[0]), (float)this.sx.area.x, (float)(this.sx.area.y - 12), 0xFFFFFF);
            this.font.func_175063_a(I18n.func_135052_a((String)"metamorph.gui.rotate", (Object[])new Object[0]), (float)this.rx.area.x, (float)(this.rx.area.y - 12), 0xFFFFFF);
        }
        super.draw(tooltip, mouseX, mouseY, partialTicks);
    }

    public static class GuiBodyPartListElement
    extends GuiListElement<BodyPart> {
        public GuiBodyPartListElement(Minecraft mc, Consumer<BodyPart> callback) {
            super(mc, callback);
            this.scroll.scrollItemSize = 16;
        }

        public void sort() {
        }

        public void drawElement(BodyPart element, int i, int x, int y, boolean hover) {
            if (this.current == i) {
                Gui.func_73734_a((int)x, (int)y, (int)(x + this.scroll.w), (int)(y + this.scroll.scrollItemSize), (int)-2013230849);
            }
            String label = i + (!element.limb.isEmpty() ? " - " + element.limb : "");
            this.font.func_175063_a(label, (float)(x + 4), (float)(y + 4), hover ? 0xFFFFA0 : 0xFFFFFF);
        }
    }
}

