/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.capabilities;

import mchorse.metamorph.Metamorph;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.capabilities.morphing.IMorphing;
import mchorse.metamorph.capabilities.morphing.Morphing;
import mchorse.metamorph.capabilities.morphing.MorphingProvider;
import mchorse.metamorph.network.Dispatcher;
import mchorse.metamorph.network.common.PacketAcquiredMorphs;
import mchorse.metamorph.network.common.PacketBlacklist;
import mchorse.metamorph.network.common.PacketMorph;
import mchorse.metamorph.network.common.PacketMorphPlayer;
import mchorse.metamorph.network.common.PacketMorphState;
import mchorse.metamorph.network.common.PacketSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class CapabilityHandler {
    public static final ResourceLocation MORPHING_CAP = new ResourceLocation("metamorph", "morphing_capability");

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent.Entity event) {
        if (!(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        event.addCapability(MORPHING_CAP, (ICapabilityProvider)new MorphingProvider());
    }

    @SubscribeEvent
    public void playerLogsIn(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        IMorphing cap = Morphing.get(player);
        if (cap != null) {
            this.sendAcquiredMorphs(cap, player);
            if (cap.isMorphed()) {
                cap.getCurrentMorph().morph((EntityLivingBase)player);
            }
            Dispatcher.sendTo(new PacketBlacklist(MorphManager.INSTANCE.activeBlacklist), (EntityPlayerMP)player);
            Dispatcher.sendTo(new PacketSettings(MorphManager.INSTANCE.activeSettings), (EntityPlayerMP)player);
            Dispatcher.sendTo(new PacketMorphState(player, cap), (EntityPlayerMP)player);
        }
    }

    @SubscribeEvent
    public void playerStartsTracking(PlayerEvent.StartTracking event) {
        if (event.getTarget() instanceof EntityPlayer) {
            Entity target = event.getTarget();
            EntityPlayerMP player = (EntityPlayerMP)event.getEntityPlayer();
            IMorphing cap = (IMorphing)target.getCapability(MorphingProvider.MORPHING_CAP, null);
            Dispatcher.sendTo(new PacketMorphPlayer(target.func_145782_y(), cap.getCurrentMorph()), player);
        }
    }

    @SubscribeEvent
    public void onPlayerSpawn(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            if (!player.field_70170_p.field_72995_K) {
                IMorphing morphing = Morphing.get(player);
                this.sendAcquiredMorphs(morphing, player);
                Dispatcher.sendTo(new PacketMorphState(player, morphing), (EntityPlayerMP)player);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        EntityPlayer player = event.getEntityPlayer();
        IMorphing morphing = Morphing.get(player);
        IMorphing oldMorphing = Morphing.get(event.getOriginal());
        if (Metamorph.proxy.config.keep_morphs || !event.isWasDeath()) {
            morphing.copy(oldMorphing, player);
        }
    }

    private void sendAcquiredMorphs(IMorphing cap, EntityPlayer player) {
        EntityPlayerMP mp = (EntityPlayerMP)player;
        Dispatcher.sendTo(new PacketMorph(cap.getCurrentMorph()), mp);
        Dispatcher.sendTo(new PacketAcquiredMorphs(cap.getAcquiredMorphs()), mp);
    }
}

