/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.capabilities.morphing;

import java.util.ArrayList;
import java.util.List;
import mchorse.metamorph.Metamorph;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.capabilities.morphing.IMorphing;
import mchorse.metamorph.capabilities.morphing.MorphingProvider;
import mchorse.metamorph.client.gui.elements.GuiSurvivalMorphs;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Morphing
implements IMorphing {
    private List<AbstractMorph> acquiredMorphs = new ArrayList<AbstractMorph>();
    private AbstractMorph morph;
    private AbstractMorph previousMorph;
    private int animation;
    private DamageSource lastDamageSource;
    private float lastHealthRatio;
    private boolean hasSquidAir = false;
    private int squidAir = 300;
    @SideOnly(value=Side.CLIENT)
    private GuiSurvivalMorphs overlay;
    private boolean hasOverlay = false;

    public static IMorphing get(EntityPlayer player) {
        if (player == null) {
            return null;
        }
        return (IMorphing)player.getCapability(MorphingProvider.MORPHING_CAP, null);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isAnimating() {
        if (Metamorph.proxy.config.disable_morph_animation) {
            return false;
        }
        return this.animation != -1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getAnimation() {
        return this.animation;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AbstractMorph getPreviousMorph() {
        return this.previousMorph;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderPlayer(EntityPlayer player, double x, double y, double z, float yaw, float partialTick) {
        if (this.morph == null && !this.isAnimating()) {
            return false;
        }
        if (this.morph == null && this.animation <= 10 || this.previousMorph == null && this.animation > 10) {
            return false;
        }
        if (!this.isAnimating()) {
            this.morph.render((EntityLivingBase)player, x, y, z, yaw, partialTick);
            return true;
        }
        GlStateManager.func_179094_E();
        if (this.animation <= 10) {
            float anim = ((float)this.animation - partialTick) / 10.0f;
            float offset = 0.0f;
            if (anim >= 0.0f) {
                offset = -anim * anim * 2.0f;
            }
            GlStateManager.func_179137_b((double)x, (double)(y + (double)offset), (double)z);
            if (anim >= 0.0f) {
                GlStateManager.func_179114_b((float)(anim * -90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)(1.0f - anim), (float)(1.0f - anim), (float)(1.0f - anim));
            }
            this.morph.render((EntityLivingBase)player, 0.0, 0.0, 0.0, yaw, partialTick);
        } else if (this.previousMorph != null) {
            float anim = ((float)(this.animation - 10) - partialTick) / 10.0f;
            float offset = 0.0f;
            if (anim >= 0.0f) {
                offset = 1.0f - anim;
            }
            GlStateManager.func_179137_b((double)x, (double)(y + (double)offset), (double)z);
            if (anim >= 0.0f) {
                GlStateManager.func_179114_b((float)((1.0f - anim) * 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)anim, (float)anim, (float)anim);
            }
            this.previousMorph.render((EntityLivingBase)player, 0.0, 0.0, 0.0, yaw, partialTick);
        }
        GlStateManager.func_179121_F();
        return true;
    }

    @Override
    public DamageSource getLastDamageSource() {
        return this.lastDamageSource;
    }

    @Override
    public void setLastDamageSource(DamageSource damageSource) {
        this.lastDamageSource = damageSource;
    }

    @Override
    public boolean acquireMorph(AbstractMorph morph) {
        if (morph == null || this.acquiredMorph(morph)) {
            return false;
        }
        this.acquiredMorphs.add(morph);
        if (this.hasOverlay) {
            this.overlay.setupMorphs(this);
        }
        return true;
    }

    @Override
    public boolean acquiredMorph(AbstractMorph morph) {
        for (AbstractMorph acquired : this.acquiredMorphs) {
            if (!acquired.equals(morph)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<AbstractMorph> getAcquiredMorphs() {
        return this.acquiredMorphs;
    }

    @Override
    public void setAcquiredMorphs(List<AbstractMorph> morphs) {
        this.acquiredMorphs.clear();
        this.acquiredMorphs.addAll(morphs);
        if (this.hasOverlay) {
            this.overlay.setupMorphs(this);
        }
    }

    @Override
    public AbstractMorph getCurrentMorph() {
        return this.morph;
    }

    @Override
    public boolean setCurrentMorph(AbstractMorph morph, EntityPlayer player, boolean force) {
        boolean creative;
        if (morph == null) {
            this.demorph(player);
            return true;
        }
        boolean bl = creative = player != null ? player.func_184812_l_() : false;
        if (force || creative || this.acquiredMorph(morph)) {
            if (player != null && this.morph != null) {
                this.morph.demorph((EntityLivingBase)player);
            }
            this.setMorph(morph, player == null ? false : player.field_70170_p.field_72995_K);
            if (player != null) {
                this.morph.morph((EntityLivingBase)player);
            }
            return true;
        }
        return false;
    }

    @Override
    public void demorph(EntityPlayer player) {
        if (player != null && this.morph != null) {
            this.morph.demorph((EntityLivingBase)player);
        }
        this.setMorph(null, player == null ? false : player.field_70170_p.field_72995_K);
    }

    protected void setMorph(AbstractMorph morph, boolean isRemote) {
        if (this.morph == null || this.morph != null && !this.morph.canMerge(morph, isRemote)) {
            if (!Metamorph.proxy.config.disable_morph_animation) {
                this.animation = 20;
            }
            this.previousMorph = this.morph;
            this.morph = morph;
        }
    }

    @Override
    public boolean isMorphed() {
        return this.morph != null;
    }

    @Override
    public boolean favorite(int index) {
        if (index >= 0 && index < this.acquiredMorphs.size()) {
            AbstractMorph morph = this.acquiredMorphs.get(index);
            boolean bl = morph.favorite = !morph.favorite;
            if (this.hasOverlay) {
                this.overlay.favorite(index);
            }
        }
        return false;
    }

    @Override
    public boolean remove(int index) {
        if (!this.acquiredMorphs.isEmpty() && index >= 0 && index < this.acquiredMorphs.size()) {
            this.acquiredMorphs.remove(index);
            if (this.hasOverlay) {
                this.overlay.remove(index);
            }
            return true;
        }
        return false;
    }

    @Override
    public void copy(IMorphing morphing, EntityPlayer player) {
        this.acquiredMorphs.addAll(morphing.getAcquiredMorphs());
        if (morphing.getCurrentMorph() != null) {
            NBTTagCompound morphNBT = new NBTTagCompound();
            morphing.getCurrentMorph().toNBT(morphNBT);
            this.setCurrentMorph(MorphManager.INSTANCE.morphFromNBT(morphNBT), player, true);
        } else {
            this.setCurrentMorph(null, player, true);
        }
    }

    @Override
    public float getLastHealthRatio() {
        return this.lastHealthRatio;
    }

    @Override
    public void setLastHealthRatio(float lastHealthRatio) {
        this.lastHealthRatio = lastHealthRatio;
    }

    @Override
    public boolean getHasSquidAir() {
        return this.hasSquidAir;
    }

    @Override
    public void setHasSquidAir(boolean hasSquidAir) {
        this.hasSquidAir = hasSquidAir;
    }

    @Override
    public int getSquidAir() {
        return this.squidAir;
    }

    @Override
    public void setSquidAir(int squidAir) {
        this.squidAir = squidAir;
    }

    @Override
    public void update(EntityPlayer player) {
        if (this.animation >= 0) {
            --this.animation;
        }
        if (this.animation == 16 && !player.field_70170_p.field_72995_K && !Metamorph.proxy.config.disable_morph_animation) {
            ((WorldServer)player.field_70170_p).func_180505_a(EnumParticleTypes.EXPLOSION_NORMAL, false, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, 25, 0.5, 0.5, 0.5, 0.05, new int[0]);
            player.func_184185_a(SoundEvents.field_187638_cR, 1.0f, 1.0f);
        }
        if (this.morph != null) {
            this.morph.update((EntityLivingBase)player, this);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiSurvivalMorphs getOverlay() {
        if (this.overlay == null) {
            this.overlay = new GuiSurvivalMorphs();
            this.overlay.setupMorphs(this);
            this.hasOverlay = true;
        }
        return this.overlay;
    }
}

