/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.client.gui;

import java.io.IOException;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.metamorph.ClientProxy;
import mchorse.metamorph.client.gui.elements.GuiSurvivalMorphs;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;

public class GuiSurvivalMenu
extends GuiBase {
    private GuiButtonElement<GuiButton> close;
    private GuiButtonElement<GuiButton> favorite;
    private GuiButtonElement<GuiButton> remove;
    private GuiButtonElement<GuiButton> onlyFavorites;
    private GuiButtonElement<GuiButton> morph;
    private GuiSurvivalMorphs morphs;

    public GuiSurvivalMenu(GuiSurvivalMorphs morphs) {
        this.morphs = morphs;
        this.morphs.inGUI = true;
        Minecraft mc = Minecraft.func_71410_x();
        this.remove = GuiButtonElement.button((Minecraft)mc, (String)I18n.func_135052_a((String)"metamorph.gui.remove", (Object[])new Object[0]), b -> {
            this.morphs.remove();
            this.updateButtons();
        });
        this.favorite = GuiButtonElement.button((Minecraft)mc, (String)"", b -> {
            this.morphs.favorite(this.morphs.morphs.get(this.morphs.index).current());
            this.updateButtons();
        });
        this.close = GuiButtonElement.button((Minecraft)mc, (String)I18n.func_135052_a((String)"metamorph.gui.close", (Object[])new Object[0]), b -> this.exit());
        this.onlyFavorites = GuiButtonElement.button((Minecraft)mc, (String)"", b -> {
            this.morphs.toggleFavorites();
            this.updateFavorites();
        });
        this.morph = GuiButtonElement.button((Minecraft)mc, (String)I18n.func_135052_a((String)"metamorph.gui.morph", (Object[])new Object[0]), b -> {
            this.morphs.selectCurrent();
            this.exit();
        });
        this.remove.resizer().parent(this.area).set(20.0f, 0.0f, 60.0f, 20.0f).y(1.0f, -30);
        this.morph.resizer().parent(this.area).set(0.0f, 0.0f, 60.0f, 20.0f).x(1.0f, -80).y(1.0f, -30);
        this.favorite.resizer().relative(this.morph.resizer()).set(-65.0f, 0.0f, 60.0f, 20.0f);
        this.close.resizer().parent(this.area).set(0.0f, 10.0f, 60.0f, 20.0f).x(1.0f, -80);
        this.onlyFavorites.resizer().relative(this.close.resizer()).set(-95.0f, 0.0f, 90.0f, 20.0f);
        this.elements.add(new IGuiElement[]{this.remove, this.favorite, this.close, this.onlyFavorites, this.morph});
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.updateFavorites();
        this.updateButtons();
    }

    private void updateFavorites() {
        this.onlyFavorites.button.field_146126_j = this.morphs.showFavorites ? I18n.func_135052_a((String)"metamorph.gui.all_morphs", (Object[])new Object[0]) : I18n.func_135052_a((String)"metamorph.gui.only_favorites", (Object[])new Object[0]);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.morphs.clickMorph(mouseX, mouseY, this.field_146294_l, this.field_146295_m);
        this.updateButtons();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.exit();
        }
        super.func_73869_a(typedChar, keyCode);
        if (ClientProxy.keys.keyPrevVarMorph.func_151463_i() == keyCode) {
            this.morphs.down();
            this.updateButtons();
        } else if (ClientProxy.keys.keyNextVarMorph.func_151463_i() == keyCode) {
            this.morphs.up();
            this.updateButtons();
        } else if (ClientProxy.keys.keyPrevMorph.func_151463_i() == keyCode) {
            this.morphs.advance(-1);
            this.updateButtons();
        } else if (ClientProxy.keys.keyNextMorph.func_151463_i() == keyCode) {
            this.morphs.advance(1);
            this.updateButtons();
        } else if (ClientProxy.keys.keyDemorph.func_151463_i() == keyCode) {
            this.morphs.skip(-1);
            this.updateButtons();
        } else if (ClientProxy.keys.keySelectMorph.func_151463_i() == keyCode) {
            this.morphs.selectCurrent();
            this.exit();
        }
    }

    private void exit() {
        this.morphs.exitGUI();
        this.field_146297_k.func_147108_a(null);
    }

    public void updateButtons() {
        int index = this.morphs.index;
        this.favorite.button.field_146124_l = index >= 0;
        this.favorite.button.field_146126_j = I18n.func_135052_a((String)"metamorph.gui.favorite", (Object[])new Object[0]);
        boolean bl = this.remove.button.field_146124_l = index >= 0;
        if (this.favorite.button.field_146124_l) {
            GuiSurvivalMorphs.MorphCell cell = this.morphs.getCurrent();
            if (cell != null) {
                this.favorite.button.field_146126_j = cell.morph.favorite ? I18n.func_135052_a((String)"metamorph.gui.unfavorite", (Object[])new Object[0]) : I18n.func_135052_a((String)"metamorph.gui.favorite", (Object[])new Object[0]);
            } else {
                this.favorite.button.field_146124_l = false;
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        Gui.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)40, (int)-2013265920);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"metamorph.gui.survival_title", (Object[])new Object[0]), 20, 16, 0xFFFFFF);
        this.morphs.render(this.field_146294_l, this.field_146295_m);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }
}

