/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.client.gui.editor;

import mchorse.mclib.client.gui.framework.GuiTooltip;
import mchorse.mclib.client.gui.framework.elements.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.GuiPanelBase;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.client.gui.editor.GuiMorphPanel;
import mchorse.metamorph.client.gui.editor.GuiNBTPanel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiAbstractMorph<T extends AbstractMorph>
extends GuiPanelBase<GuiMorphPanel> {
    public static final ResourceLocation PANEL_ICONS = new ResourceLocation("metamorph:textures/gui/icons.png");
    public GuiButtonElement<GuiButton> finish;
    public GuiNBTPanel nbt;
    protected GuiMorphPanel defaultPanel;
    public T morph;

    public GuiAbstractMorph(Minecraft mc) {
        super(mc);
        this.createChildren();
        this.finish = GuiButtonElement.button((Minecraft)mc, (String)I18n.func_135052_a((String)"metamorph.gui.finish", (Object[])new Object[0]), null);
        this.finish.resizer().parent(this.area).set(0.0f, 10.0f, 55.0f, 20.0f).x(1.0f, -65);
        this.nbt = new GuiNBTPanel(mc, this);
        this.defaultPanel = this.nbt;
        this.registerPanel((IGuiElement)this.nbt, PANEL_ICONS, I18n.func_135052_a((String)"metamorph.gui.panels.nbt", (Object[])new Object[0]), 0, 0, 0, 16);
        this.children.elements.add(2, this.finish);
    }

    public void setPanel(GuiMorphPanel panel) {
        if (this.view.delegate != null) {
            ((GuiMorphPanel)this.view.delegate).finishEditing();
        }
        super.setPanel((IGuiElement)panel);
        panel.startEditing();
    }

    public boolean canEdit(AbstractMorph morph) {
        return morph != null;
    }

    public void startEdit(T morph) {
        this.morph = morph;
        for (GuiMorphPanel panel : this.panels) {
            panel.fillData(morph);
        }
        this.setPanel(this.defaultPanel);
    }

    public void finishEdit() {
        if (this.view.delegate != null) {
            ((GuiMorphPanel)this.view.delegate).finishEditing();
        }
    }

    public void draw(GuiTooltip tooltip, int mouseX, int mouseY, float partialTicks) {
        this.drawMorph(mouseX, mouseY, partialTicks);
        super.draw(tooltip, mouseX, mouseY, partialTicks);
    }

    protected void drawMorph(int mouseX, int mouseY, float partialTicks) {
        try {
            ((AbstractMorph)this.morph).renderOnScreen((EntityPlayer)this.mc.field_71439_g, this.area.getX(0.5f), this.area.getY(0.66f), this.area.h / 3, 1.0f);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

