/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.entity;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Iterator;
import java.util.UUID;
import mchorse.metamorph.api.MorphAPI;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.models.IMorphProvider;
import mchorse.metamorph.api.morphs.AbstractMorph;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketCollectItem;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityMorph
extends EntityLivingBase
implements IEntityAdditionalSpawnData,
IMorphProvider {
    private String username;
    private UUID owner;
    private boolean ownerless = true;
    private EntityPlayer player;
    public int timer = 30;
    public int lifetime = 2400;
    public AbstractMorph morph;

    public EntityMorph(World worldIn) {
        super(worldIn);
        this.func_184224_h(true);
        this.func_96094_a("Morph");
    }

    public EntityMorph(World worldIn, UUID owner, AbstractMorph morph) {
        this(worldIn);
        this.owner = owner;
        this.morph = morph;
        this.ownerless = false;
        this.setSize(morph);
    }

    @Override
    public AbstractMorph getMorph() {
        return this.morph;
    }

    public ITextComponent func_145748_c_() {
        if (this.morph != null) {
            return new TextComponentTranslation("entity." + this.morph.name + ".name", new Object[0]);
        }
        return super.func_145748_c_();
    }

    private void setSize(AbstractMorph morph) {
        if (morph != null) {
            this.func_70105_a(MathHelper.func_76131_a((float)morph.getWidth(this), (float)0.0f, (float)1.5f), MathHelper.func_76131_a((float)morph.getHeight(this), (float)0.0f, (float)2.0f));
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_85033_bc() {
    }

    public void func_70071_h_() {
        this.field_70179_y = 0.0;
        this.field_70159_w = 0.0;
        super.func_70071_h_();
        if (this.timer > 0) {
            --this.timer;
            return;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            if (this.lifetime > 0) {
                --this.lifetime;
            } else if (this.lifetime == 0) {
                this.func_70106_y();
            }
            this.updateMorph();
        }
    }

    private void updateMorph() {
        if (this.ownerless) {
            Iterator iterator = this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ()).iterator();
            if (iterator.hasNext()) {
                EntityPlayer player = (EntityPlayer)iterator.next();
                this.grantMorph(player);
            }
        } else {
            if (this.player == null || this.player.field_70128_L) {
                if (this.owner != null) {
                    this.player = this.field_70170_p.func_152378_a(this.owner);
                } else if (this.username != null) {
                    this.player = this.field_70170_p.func_72924_a(this.username);
                }
            }
            if (this.player != null && this.func_174813_aQ().func_72326_a(this.player.func_174813_aQ())) {
                this.grantMorph(this.player);
            }
        }
    }

    protected void grantMorph(EntityPlayer player) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (MorphAPI.acquire(player, this.morph)) {
            this.field_70170_p.func_184148_a(player, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.AMBIENT, 1.0f, 1.0f);
            ((WorldServer)this.field_70170_p).func_73039_n().func_151247_a((Entity)this, (Packet)new SPacketCollectItem(this.func_145782_y(), player.func_145782_y(), 1));
        }
        this.func_70106_y();
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("LifeTime", this.lifetime);
        compound.func_74757_a("Ownerless", this.ownerless);
        if (this.username != null && !this.username.isEmpty()) {
            compound.func_74778_a("Username", this.username);
        }
        if (this.owner != null) {
            compound.func_74778_a("Owner", this.owner.toString());
        }
        if (this.morph != null) {
            NBTTagCompound tag = new NBTTagCompound();
            this.morph.toNBT(tag);
            compound.func_74782_a("Morph", (NBTBase)tag);
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        String owner = compound.func_74779_i("Owner");
        UUID uUID = this.owner = owner.isEmpty() ? null : UUID.fromString(owner);
        if (compound.func_150297_b("LifeTime", 99)) {
            this.lifetime = compound.func_74762_e("LifeTime");
        }
        if (this.owner != null) {
            this.ownerless = false;
        }
        if (compound.func_150297_b("Username", 8)) {
            this.username = compound.func_74779_i("Username");
            this.ownerless = false;
        } else if (compound.func_74764_b("Ownerless")) {
            this.ownerless = compound.func_74767_n("Ownerless");
        }
        if (compound.func_150297_b("Morph", 10)) {
            this.morph = MorphManager.INSTANCE.morphFromNBT(compound.func_74775_l("Morph"));
        }
        this.setSize(this.morph);
    }

    public void writeSpawnData(ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)(this.owner != null ? this.owner.toString() : ""));
        if (this.morph != null) {
            NBTTagCompound tag = new NBTTagCompound();
            this.morph.toNBT(tag);
            boolean hasData = tag != null && !tag.func_82582_d();
            buffer.writeBoolean(hasData);
            if (hasData) {
                ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)tag);
            }
        }
    }

    public void readSpawnData(ByteBuf buffer) {
        String owner = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        UUID uUID = this.owner = owner.isEmpty() ? null : UUID.fromString(owner);
        if (buffer.readBoolean()) {
            NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buffer);
            this.morph = MorphManager.INSTANCE.morphFromNBT(tag);
        }
        this.setSize(this.morph);
    }

    public Iterable<ItemStack> func_184193_aE() {
        return Arrays.asList(new ItemStack[0]);
    }

    public ItemStack func_184582_a(EntityEquipmentSlot slotIn) {
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(EntityEquipmentSlot slotIn, ItemStack stack) {
    }

    public EnumHandSide func_184591_cq() {
        return EnumHandSide.RIGHT;
    }
}

