/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.util;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DevMappings {
    static Map<String, String> srgToMcp;

    public static String get(String srgname) {
        return srgToMcp.get(srgname);
    }

    static {
        String mappingFileProp = System.getProperty("net.minecraftforge.gradle.GradleStart.srg.srg-mcp");
        if (!Strings.isNullOrEmpty((String)mappingFileProp)) {
            try {
                srgToMcp = new HashMap<String, String>();
                List mappingLines = Files.readLines((File)new File(mappingFileProp), (Charset)Charsets.UTF_8);
                for (String line : mappingLines) {
                    String mcp;
                    String srg;
                    String[] parts = line.split(" ");
                    if (parts[0].equals("FD:")) {
                        srg = parts[1].substring(parts[1].lastIndexOf("/") + 1);
                        mcp = parts[2].substring(parts[2].lastIndexOf("/") + 1);
                        srgToMcp.put(srg, mcp);
                        continue;
                    }
                    if (!parts[0].equals("MD:")) continue;
                    srg = parts[1].substring(parts[1].lastIndexOf("/") + 1);
                    mcp = parts[3].substring(parts[3].lastIndexOf("/") + 1);
                    srgToMcp.put(srg, mcp);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

