/*
 * Decompiled with CFR 0.152.
 */
package mchorse.vanilla_pack;

import java.util.List;
import mchorse.metamorph.api.EntityUtils;
import mchorse.metamorph.api.IMorphFactory;
import mchorse.metamorph.api.MorphList;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.api.morphs.EntityMorph;
import mchorse.metamorph.client.gui.editor.GuiAbstractMorph;
import mchorse.vanilla_pack.morphs.BlockMorph;
import mchorse.vanilla_pack.morphs.IronGolemMorph;
import mchorse.vanilla_pack.morphs.ShulkerMorph;
import mchorse.vanilla_pack.morphs.UndeadMorph;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityGiantZombie;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MobMorphFactory
implements IMorphFactory {
    @Override
    public void register(MorphManager manager) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerClient(MorphManager manager) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerMorphEditors(List<GuiAbstractMorph> editors) {
        editors.add(new GuiAbstractMorph(Minecraft.func_71410_x()));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String displayNameForMorph(AbstractMorph morphName) {
        return null;
    }

    @Override
    public void getMorphs(MorphList morphs, World world) {
        int i;
        for (ResourceLocation rl : EntityList.func_180124_b()) {
            String name = rl.toString();
            if (!this.hasMorph(name) || morphs.hasMorph(name)) continue;
            this.addMorph(morphs, world, name, null);
        }
        this.addMorph(morphs, world, "minecraft:pig", "{Age:-1}");
        this.addMorph(morphs, world, "minecraft:chicken", "{Age:-1}");
        this.addMorph(morphs, world, "minecraft:cow", "{Age:-1}");
        this.addMorph(morphs, world, "minecraft:mooshroom", "{Age:-1}");
        this.addMorph(morphs, world, "minecraft:polar_bear", "{Age:-1}");
        this.addMorph(morphs, world, "minecraft:sheep", "{Sheared:1b}");
        this.addMorph(morphs, world, "minecraft:sheep", "{Age:-1}");
        this.addMorph(morphs, world, "minecraft:sheep", "{Age:-1,Sheared:1b}");
        for (i = 1; i < 16; ++i) {
            this.addMorph(morphs, world, "minecraft:sheep", "{Color:" + i + "}");
        }
        this.addMorph(morphs, world, "minecraft:sheep", "Jeb", "{CustomName:\"jeb_\"}");
        this.addMorph(morphs, world, "minecraft:sheep", "Baby Jeb", "{Age:-1,CustomName:\"jeb_\"}");
        this.addMorph(morphs, world, "minecraft:slime", "{Size:1}");
        this.addMorph(morphs, world, "minecraft:slime", "{Size:2}");
        this.addMorph(morphs, world, "minecraft:magma_cube", "{Size:1}");
        this.addMorph(morphs, world, "minecraft:magma_cube", "{Size:2}");
        this.addMorph(morphs, world, "minecraft:ocelot", "{Age:-1}");
        for (i = 1; i < 4; ++i) {
            this.addMorph(morphs, world, "minecraft:ocelot", "{CatType:" + i + "}");
            this.addMorph(morphs, world, "minecraft:ocelot", "{CatType:" + i + ",Age:-1}");
        }
        this.addMorph(morphs, world, "minecraft:horse", "{Variant:1}");
        this.addMorph(morphs, world, "minecraft:horse", "{Variant:2}");
        this.addMorph(morphs, world, "minecraft:horse", "{Variant:3}");
        this.addMorph(morphs, world, "minecraft:horse", "{Variant:4}");
        this.addMorph(morphs, world, "minecraft:horse", "{Variant:5}");
        this.addMorph(morphs, world, "minecraft:horse", "{Variant:6}");
        this.addMorph(morphs, world, "minecraft:villager", "{ProfessionName:\"minecraft:librarian\"}");
        this.addMorph(morphs, world, "minecraft:villager", "{ProfessionName:\"minecraft:priest\"}");
        this.addMorph(morphs, world, "minecraft:villager", "{ProfessionName:\"minecraft:smith\"}");
        this.addMorph(morphs, world, "minecraft:villager", "{ProfessionName:\"minecraft:butcher\"}");
        this.addMorph(morphs, world, "minecraft:villager", "{ProfessionName:\"minecraft:nitwit\"}");
        for (i = 1; i < 6; ++i) {
            this.addMorph(morphs, world, "minecraft:zombie_villager", "{Profession:" + i + "}");
        }
        this.addMorph(morphs, world, "minecraft:bat", "{BatFlags:2}");
        this.addMorph(morphs, world, "minecraft:zombie", "Baby", "{IsBaby:1b}");
        for (i = 1; i < 4; ++i) {
            this.addMorph(morphs, world, "minecraft:llama", "{Variant:" + i + "}");
        }
        for (i = 1; i < 6; ++i) {
            this.addMorph(morphs, world, "minecraft:rabbit", "{RabbitType:" + i + "}");
        }
        this.addMorph(morphs, world, "minecraft:rabbit", "Toast", "{CustomName:\"Toast\"}");
        this.addBlockMorph(morphs, world, "{Block:\"minecraft:stone\"}");
        this.addBlockMorph(morphs, world, "{Block:\"minecraft:cobblestone\"}");
        this.addBlockMorph(morphs, world, "{Block:\"minecraft:grass\"}");
        this.addBlockMorph(morphs, world, "{Block:\"minecraft:dirt\"}");
        this.addBlockMorph(morphs, world, "{Block:\"minecraft:log\"}");
        this.addBlockMorph(morphs, world, "{Block:\"minecraft:diamond_block\"}");
        this.addBlockMorph(morphs, world, "{Block:\"minecraft:sponge\"}");
        this.addBlockMorph(morphs, world, "{Block:\"minecraft:deadbush\"}");
    }

    private void addMorph(MorphList morphs, World world, String name, String json) {
        this.addMorph(morphs, world, name, "", json);
    }

    private void addMorph(MorphList morphs, World world, String name, String variant, String json) {
        try {
            EntityMorph morph = this.morphFromName(name);
            EntityLivingBase entity = (EntityLivingBase)EntityList.func_188429_b((ResourceLocation)new ResourceLocation(name), (World)world);
            if (entity == null) {
                System.out.println("Couldn't add morph " + name + ", because it's null!");
                return;
            }
            NBTTagCompound data = entity.serializeNBT();
            morph.name = name;
            if (json != null) {
                try {
                    data.func_179237_a(JsonToNBT.func_180713_a((String)json));
                }
                catch (NBTException e) {
                    System.out.println("Failed to merge provided JSON data for '" + name + "' morph!");
                    e.printStackTrace();
                }
            }
            String category = "";
            if (!name.startsWith("minecraft:")) {
                category = name.substring(0, name.indexOf(":"));
            } else if (entity instanceof EntityDragon || entity instanceof EntityWither || entity instanceof EntityGiantZombie) {
                category = "boss";
            } else if (entity instanceof EntityAnimal || name.equals("minecraft:bat") || name.equals("minecraft:squid")) {
                category = "animal";
            } else if (entity instanceof EntityMob || name.equals("minecraft:ghast") || name.equals("minecraft:magma_cube") || name.equals("minecraft:slime") || name.equals("minecraft:shulker")) {
                category = "hostile";
            }
            EntityUtils.stripEntityNBT(data);
            morph.setEntityData(data);
            morphs.addMorphVariant(name, category, variant, morph);
        }
        catch (Exception e) {
            System.out.println("An error occured during insertion of " + name + " morph!");
            e.printStackTrace();
        }
    }

    private void addBlockMorph(MorphList morphs, World world, String json) {
        try {
            BlockMorph morph = new BlockMorph();
            NBTTagCompound tag = JsonToNBT.func_180713_a((String)json);
            tag.func_74778_a("Name", morph.name);
            morph.fromNBT(tag);
            morphs.addMorphVariant("block", "blocks", morph.block.func_177230_c().func_149732_F(), morph);
        }
        catch (Exception e) {
            System.out.println("Failed to create a block morph with the data! " + json);
            e.printStackTrace();
        }
    }

    @Override
    public boolean hasMorph(String name) {
        if (name.equals("metamorph.Block")) {
            return true;
        }
        Class clazz = null;
        ResourceLocation key = new ResourceLocation(name);
        for (EntityEntry entity : ForgeRegistries.ENTITIES) {
            if (!entity.getRegistryName().equals((Object)key)) continue;
            clazz = entity.getEntityClass();
        }
        return clazz == null ? false : EntityLivingBase.class.isAssignableFrom(clazz);
    }

    @Override
    public AbstractMorph getMorphFromNBT(NBTTagCompound tag) {
        String name = tag.func_74779_i("Name");
        if (MorphManager.NAME_TO_RL.containsKey(name)) {
            name = MorphManager.NAME_TO_RL.get(name).toString();
            tag.func_74778_a("Name", name);
        }
        if (name.equals("metamorph.Block")) {
            BlockMorph morph = new BlockMorph();
            morph.fromNBT(tag);
            return morph;
        }
        if (this.hasMorph(name)) {
            EntityMorph morph = this.morphFromName(name);
            morph.fromNBT(tag);
            return morph;
        }
        return null;
    }

    public EntityMorph morphFromName(String name) {
        if (name.equals("minecraft:zombie") || name.equals("minecraft:skeleton") || name.equals("minecraft:zombie_villager")) {
            return new UndeadMorph();
        }
        if (name.equals("minecraft:villager_golem")) {
            return new IronGolemMorph();
        }
        if (name.equals("minecraft:shulker")) {
            return new ShulkerMorph();
        }
        return new EntityMorph();
    }
}

