/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph;

import java.lang.reflect.Field;
import java.util.Map;
import mchorse.metamorph.CommonProxy;
import mchorse.metamorph.Metamorph;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.client.KeyboardHandler;
import mchorse.metamorph.client.RenderingHandler;
import mchorse.metamorph.client.gui.elements.GuiOverlay;
import mchorse.metamorph.client.gui.elements.GuiSurvivalMorphs;
import mchorse.metamorph.client.render.RenderCustomModel;
import mchorse.metamorph.client.render.RenderMorph;
import mchorse.metamorph.client.render.RenderSubPlayer;
import mchorse.metamorph.entity.EntityMorph;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    public static GuiSurvivalMorphs overlay = new GuiSurvivalMorphs();
    public static GuiOverlay morphOverlay = new GuiOverlay();
    public static RenderCustomModel modelRenderer;
    public static KeyboardHandler keys;

    @Override
    public void preLoad(FMLPreInitializationEvent event) {
        super.preLoad(event);
        RenderingRegistry.registerEntityRenderingHandler(EntityMorph.class, (IRenderFactory)new RenderMorph.MorphFactory());
    }

    @Override
    public void load() {
        RenderManager manager = Minecraft.func_71410_x().func_175598_ae();
        modelRenderer = new RenderCustomModel(manager, null, 0.5f);
        this.substitutePlayerRenderers(manager);
        super.load();
        MinecraftForge.EVENT_BUS.register((Object)new RenderingHandler(overlay, morphOverlay));
        keys = new KeyboardHandler(overlay);
        MinecraftForge.EVENT_BUS.register((Object)keys);
        MorphManager.INSTANCE.registerClient();
    }

    private void substitutePlayerRenderers(RenderManager manager) {
        Map skins = null;
        for (Field field : manager.getClass().getDeclaredFields()) {
            if (!field.getType().equals(Map.class)) continue;
            field.setAccessible(true);
            try {
                Map map = (Map)field.get(manager);
                if (!(map.get("default") instanceof RenderPlayer)) continue;
                skins = map;
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (skins != null) {
            skins.put("slim", new RenderSubPlayer(manager, true));
            skins.put("default", new RenderSubPlayer(manager, false));
            Metamorph.log("Skin map renderers were successfully replaced with Metamorph substitutes!");
        }
    }
}

